/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.alerters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.AlerterSkeleton;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.DateUtils;
import uk.org.iscream.cms.server.util.FormatName;

public class IRC__Alerter
extends AlerterSkeleton {
    public final String REVISION = "$Revision: 1.29 $";
    public final String DESC = "Sends alerts on an IRC channel";
    public final int DEFAULT_RECONNECT_DELAY = 30;
    private IRCBot _ircbot = new IRCBot();
    private boolean _active = false;
    private String _lastAlert = "no alerts have been sent";
    private long _lastAlertTime = -1L;
    private int _alertCount = 0;
    private int _ignoredCount = 0;
    private long _startTime;
    private String _name = "IRC";

    public IRC__Alerter() {
        this._ircbot.setName("client.IRC__Alerter$IRCBot");
        this._ircbot.start();
        this._startTime = System.currentTimeMillis();
        this._logger.write(this.toString(), 4, "IRC Alerter started");
    }

    public void sendAlert(Alert alert) {
        String string;
        String string2 = Alert.alertLevels[alert.getLevel()];
        try {
            string = this._cp.getProperty(this._name, "Alerter.IRC.message");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            string = "<NOT CONFIGURED>";
            this._logger.write(this.toString(), 2, "Alerter.IRC.message value unavailable using default of " + string);
        }
        string = this.processAlertMessage(string, alert);
        if (this._active) {
            this._logger.write(this.toString(), 5, "Sending " + this._name + " at " + string2 + " level");
            this._ircbot.sendMsg(string);
            ++this._alertCount;
        } else {
            ++this._ignoredCount;
        }
        this._lastAlert = string;
        this._lastAlertTime = System.currentTimeMillis();
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.29 $");
    }

    public String getDescription() {
        return "Sends alerts on an IRC channel";
    }

    protected String getFName() {
        return this._name;
    }

    class IRCBot
    extends Thread {
        public static final String DEFAULT_STARTUP_NOTICE = "i-scream ircbot starting...";
        private Socket _socket;
        private PrintWriter _socketOut;
        private BufferedReader _socketIn;
        private String _channel;
        private String _nickname;
        protected Logger _logger = ReferenceManager.getInstance().getLogger();

        IRCBot() {
        }

        public void run() {
            boolean bl = true;
            while (bl) {
                String string;
                boolean bl2 = true;
                try {
                    string = ConfigurationProxy.getInstance().getProperty(IRC__Alerter.this._name, "Alerter.IRC.startupNotice");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    string = DEFAULT_STARTUP_NOTICE;
                    this._logger.write(this.toString(), 2, "Configuration error: " + propertyNotFoundException);
                }
                try {
                    this.connect();
                    this.sendNotice(string);
                }
                catch (IOException iOException) {
                    bl2 = false;
                    this._logger.write(this.toString(), 1, "Error connecting: " + iOException);
                }
                while (bl2) {
                    try {
                        String string2 = this._socketIn.readLine();
                        if (string2 == null) {
                            throw new IOException("End of stream reached");
                        }
                        this.handleInput(string2);
                    }
                    catch (IOException iOException) {
                        this._logger.write(this.toString(), 1, "Communication error: " + iOException);
                        bl2 = false;
                    }
                }
                try {
                    this.disconnect();
                }
                catch (IOException iOException) {
                    this._logger.write(this.toString(), 1, "Communication error: " + iOException);
                }
                int n = 0;
                try {
                    n = Integer.parseInt(ConfigurationProxy.getInstance().getProperty(IRC__Alerter.this._name, "Alerter.IRC.reconnectDelay"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 30;
                    this._logger.write(this.toString(), 2, "Erronous Alerter.IRC.reconnectDelay value in configuration using default of " + n + " seconds");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    n = 30;
                    this._logger.write(this.toString(), 2, "Alerter.IRC.reconnectDelay value unavailable using default of " + n + " seconds");
                }
                try {
                    Thread.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void sendMsg(String string) {
            this._socketOut.println("PRIVMSG " + this._channel + " :" + string);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void sendPrivMsg(String string, String string2) {
            this._socketOut.println("PRIVMSG " + string + " :" + string2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void sendAction(String string) {
            char c = '\u0001';
            this.sendMsg(c + "ACTION " + string + c);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void sendNotice(String string) {
            this._socketOut.println("NOTICE " + this._channel + " :" + string);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void connect() throws IOException {
            String string;
            String string2;
            String string3;
            int n;
            String string4;
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            try {
                string4 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.IRCServer");
                n = Integer.parseInt(configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.IRCPort"));
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                throw new IOException("Can't get irc server details due to configuration error");
            }
            catch (NumberFormatException numberFormatException) {
                this._logger.write(this.toString(), 1, "Configuration error: " + numberFormatException);
                throw new IOException("Can't get irc server details due to malformed configuration");
            }
            this._socket = new Socket(string4, n);
            this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
            this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
            try {
                string3 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.user");
                string2 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.comment");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                throw new IOException("Can't get user details due to configuration error");
            }
            this._socketOut.println("USER " + string3 + " 8 * :" + string2);
            try {
                string = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.nickList");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                throw new IOException("Can't get nickname due to configuration error");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            boolean bl = false;
            while (!bl && stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                this._socketOut.println("NICK " + string5);
                String string6 = "";
                do {
                    if ((string6 = this._socketIn.readLine()) != null) continue;
                    throw new IOException("Communication error whilst logging in");
                } while (string6.indexOf("001") == -1 && string6.indexOf("433") == -1);
                if (string6.indexOf("001") != -1) {
                    bl = true;
                    this._nickname = string5;
                    continue;
                }
                this._logger.write(this.toString(), 2, "Nickname in use: " + string5);
            }
            if (!bl) {
                throw new IOException("All nicknames in use");
            }
            try {
                this._channel = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.channel");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                throw new IOException("Can't get channel name due to configuration error");
            }
            this._socketOut.println("JOIN " + this._channel);
            IRC__Alerter.this._active = true;
        }

        public void disconnect() throws IOException {
            IRC__Alerter.this._active = false;
            this._socketOut.println("QUIT : iscreamBot component shutting down...");
            this._socketOut.close();
            this._socketIn.close();
            this._socket.close();
        }

        public String toString() {
            return FormatName.getName(IRC__Alerter.this._name, this.getClass().getName(), "$Revision: 1.29 $");
        }

        private void handleInput(String string) {
            ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
            if (string.startsWith("PING")) {
                this._socketOut.println("PONG" + string.substring(4));
            } else if (this.getMsg(string).startsWith(this._nickname + ",") || this.getMsg(string).startsWith(this._nickname + ":") || this.getMsg(string).startsWith(this._nickname + " ")) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                try {
                    string11 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.stopCommand");
                    string10 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.startCommand");
                    string9 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.timeSinceLastAlertCommand");
                    string8 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.lastAlertCommand");
                    string7 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.joinCommand");
                    string6 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.nickChangeCommand");
                    string5 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.versionCommand");
                    string4 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.helpCommand");
                    string3 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.statCommand");
                    string2 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.uptimeCommand");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                    return;
                }
                String string12 = this.getMsg(string).substring(this._nickname.length());
                if (string12.indexOf(string11) != -1) {
                    IRC__Alerter.this._active = false;
                    this.sendMsg(this.getMsgSender(string) + ", alerts have been stopped");
                } else if (string12.indexOf(string10) != -1) {
                    IRC__Alerter.this._active = true;
                    this.sendMsg(this.getMsgSender(string) + ", alerts have been activated");
                } else if (string12.indexOf(string9) != -1) {
                    if (IRC__Alerter.this._lastAlertTime != -1L) {
                        long l = (System.currentTimeMillis() - IRC__Alerter.this._lastAlertTime) / 1000L;
                        String string13 = DateUtils.formatTime(l, "%DAYS% days, %HOURS% hours, %MINS% mins, and %SECS% secs");
                        this.sendMsg(this.getMsgSender(string) + ", I last sent an alert " + string13 + " ago");
                    } else {
                        this.sendMsg(this.getMsgSender(string) + ", I've never sent an alert!");
                    }
                } else if (string12.indexOf(string8) != -1) {
                    if (IRC__Alerter.this._lastAlertTime != -1L) {
                        String string14 = DateFormat.getDateTimeInstance(3, 3, Locale.UK).format(new Date(IRC__Alerter.this._lastAlertTime));
                        this.sendMsg(this.getMsgSender(string) + ", last alert was at " + string14 + "; " + IRC__Alerter.this._lastAlert);
                    } else {
                        this.sendMsg(this.getMsgSender(string) + ", I've never sent an alert!");
                    }
                } else if (string12.indexOf(string7) != -1) {
                    String string15 = string7;
                    String string16 = string12.substring(string12.indexOf(string15) + string15.length() + 1);
                    int n = string16.indexOf(" ");
                    if (n == -1) {
                        n = string16.length();
                    }
                    if ((string16 = string16.substring(0, n)).equals(this._channel)) {
                        this.sendMsg(this.getMsgSender(string) + ", I'm already on " + string16 + "!");
                    } else {
                        this.sendMsg(this.getMsgSender(string) + ", okay, I'm off to " + string16);
                        this._socketOut.println("PART " + this._channel);
                        this._socketOut.println("JOIN " + string16);
                        this._channel = string16;
                    }
                } else if (string12.indexOf(string6) != -1) {
                    String string17 = string6;
                    String string18 = string12.substring(string12.indexOf(string17) + string17.length() + 1);
                    int n = string18.indexOf(" ");
                    if (n == -1) {
                        n = string18.length();
                    }
                    string18 = string18.substring(0, n);
                    this.sendMsg(this.getMsgSender(string) + ", okay, changing my nickname to " + string18);
                    this._socketOut.println("NICK " + string18);
                    this._nickname = string18;
                } else if (string12.indexOf(string5) != -1) {
                    this.sendMsg(this.getMsgSender(string) + ", I am version " + "$Revision: 1.29 $".substring(11, "$Revision: 1.29 $".length() - 2) + " of the i-scream alerting bot");
                } else if (string12.indexOf(string4) != -1) {
                    this.sendPrivMsg(this.getMsgSender(string), "Hello, I am the i-scream alerting bot version " + "$Revision: 1.29 $".substring(11, "$Revision: 1.29 $".length() - 2));
                    this.sendPrivMsg(this.getMsgSender(string), "I understand the following commands;");
                    this.sendPrivMsg(this.getMsgSender(string), string11);
                    this.sendPrivMsg(this.getMsgSender(string), string10);
                    this.sendPrivMsg(this.getMsgSender(string), string8);
                    this.sendPrivMsg(this.getMsgSender(string), string7);
                    this.sendPrivMsg(this.getMsgSender(string), string6);
                    this.sendPrivMsg(this.getMsgSender(string), string3);
                    this.sendPrivMsg(this.getMsgSender(string), string2);
                    this.sendPrivMsg(this.getMsgSender(string), string9);
                    this.sendPrivMsg(this.getMsgSender(string), string4);
                } else if (string12.indexOf(string3) != -1) {
                    this.sendMsg(this.getMsgSender(string) + ", I have sent a total of " + IRC__Alerter.this._alertCount + " alerts, and ignored a total of " + IRC__Alerter.this._ignoredCount + "!");
                } else if (string12.indexOf(string2) != -1) {
                    long l = (System.currentTimeMillis() - IRC__Alerter.this._startTime) / 1000L;
                    String string19 = DateUtils.formatTime(l, "%DAYS% days, %HOURS% hours, %MINS% mins, and %SECS% secs");
                    this.sendMsg(this.getMsgSender(string) + ", I have been running for " + string19);
                } else if (string12.indexOf("ping") != -1) {
                    this.sendMsg("pong");
                } else if (string12.indexOf("do a jibble dance") != -1) {
                    this.sendAction("jives to the funky beat shouting \"ii--screeeaaammm\"");
                } else {
                    String string20 = "<NOT CONFIGURED>";
                    try {
                        string20 = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.rejectMessage");
                    }
                    catch (PropertyNotFoundException propertyNotFoundException) {
                        this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                    }
                    this.sendMsg(this.getMsgSender(string) + ", " + string20);
                }
            } else if (string.indexOf(this._nickname) != -1 && string.indexOf(this._channel) != -1 && string.indexOf("KICK") != -1) {
                this.sendPrivMsg(this.getMsgSender(string), "That wasn't a nice thing to do...");
                try {
                    this._channel = configurationProxy.getProperty(IRC__Alerter.this._name, "Alerter.IRC.channel");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    this._logger.write(this.toString(), 1, "Configuration error: " + propertyNotFoundException);
                }
                this._socketOut.println("JOIN " + this._channel);
            }
        }

        private String getMsg(String string) {
            int n;
            int n2;
            String string2 = "";
            if (string.indexOf("PRIVMSG") != -1 && (n2 = string.indexOf(":")) != -1 && (n = string.indexOf(":", n2 + 1)) != -1) {
                string2 = string.substring(n + 1);
            }
            return string2;
        }

        private String getMsgSender(String string) {
            String string2 = "";
            int n = string.indexOf(":");
            int n2 = string.indexOf("!");
            if (n != -1 && n2 != -1) {
                string2 = string.substring(n + 1, n2);
            }
            return string2;
        }
    }
}

