/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client.alerters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.AlerterSkeleton;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Smtp;

public class EMail__Alerter
extends AlerterSkeleton {
    public final String REVISION = "$Revision: 1.24 $";
    public final String DESC = "Sends alerts over e-mail.";
    protected String _name = "EMail";

    public void sendAlert(Alert alert) {
        String string;
        String string2;
        try {
            string2 = this._cp.getProperty(this._name, "Alerter.EMail.subject");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            string2 = "<NOT CONFIGURED>";
            this._logger.write(this.toString(), 2, "Alerter.EMail.subject value unavailable using default of " + string2);
        }
        string2 = this.processAlertMessage(string2, alert);
        try {
            string = this._cp.getProperty(this._name, "Alerter.EMail.message");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            string = "<NOT CONFIGURED>";
            this._logger.write(this.toString(), 2, "Alerter.EMail.message value unavailable using default of " + string);
        }
        string = this.processAlertMessage(string, alert);
        try {
            Smtp smtp = new Smtp(this._cp.getProperty(this._name, "Alerter.EMail.smtpServer"));
            smtp.setSender(this._cp.getProperty(this._name, "Alerter.EMail.sender"));
            String string3 = this._cp.getProperty("Host." + alert.getSource(), "Alerter.EMail.destList");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                smtp.setTo(stringTokenizer.nextToken());
            }
            PrintWriter printWriter = smtp.getOutputStream();
            printWriter.println("Subject: " + string2 + "\n");
            printWriter.println(string);
            smtp.sendMessage();
            smtp.close();
            this._logger.write(this.toString(), 5, "Sending " + this._name + " at " + Alert.alertLevels[alert.getLevel()] + " level");
        }
        catch (IOException iOException) {
            this._logger.write(this.toString(), 1, "Error whilst sending message: " + iOException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 1, "Error obtaining essential configuration: " + propertyNotFoundException);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.24 $");
    }

    public String getDescription() {
        return "Sends alerts over e-mail.";
    }

    protected String getFName() {
        return this._name;
    }
}

