/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.AlerterManager;
import uk.org.iscream.cms.server.client.PluginMonitor;
import uk.org.iscream.cms.server.client.Register;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;

public abstract class MonitorSkeleton
extends Thread
implements PluginMonitor {
    public final String REVISION = "$Revision: 1.12 $";
    protected Logger _logger = ReferenceManager.getInstance().getLogger();
    protected Queue _alerterQueue = AlerterManager.getInstance().getQueue();
    protected int _qID = -1;
    protected boolean _running = true;

    public MonitorSkeleton() {
        this._logger.write(this.toString(), 4, "started.");
        this.start();
    }

    public void run() {
        while (this._running) {
            try {
                this.analysePacket((XMLPacket)this.getQueue().get(this.getQueueId()));
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Unable to get queue.");
            }
        }
    }

    protected abstract void analysePacket(XMLPacket var1);

    protected void processAlert(int n, String string, Register register, String string2, String string3) {
        long l;
        if (n != register.getLastThresholdLevel()) {
            register.setLastThresholdLevel(n);
        }
        if (register.getLastThresholdLevel() != 0) {
            long l2 = register.getLastAlertTimeout();
            if (l2 > 0L && register.getTimeLastSent() > 0L) {
                if (System.currentTimeMillis() - register.getTimeLastSent() > l2) {
                    int n2 = register.getLastAlertLevel();
                    register.escalateAlert();
                    register.setTimeLastSent(System.currentTimeMillis());
                    register.setLastAlertTimeout(register.getAlertTimeout(register.getLastAlertLevel()));
                    this.fireAlert(register, n2, string2, string3, string);
                }
            } else {
                int n3 = register.getLastAlertLevel();
                register.escalateAlert();
                register.setTimeLastSent(System.currentTimeMillis());
                register.setLastAlertTimeout(register.getAlertTimeout(register.getLastAlertLevel()));
                this.fireAlert(register, n3, string2, string3, string);
            }
        } else if (register.getLastAlertLevel() != 0 && (l = register.getLastAlertTimeout()) > 0L && register.getTimeLastSent() > 0L && System.currentTimeMillis() - register.getTimeLastSent() > l) {
            int n4 = register.getLastAlertLevel();
            register.setLastAlertLevel(0);
            register.setTimeLastSent(System.currentTimeMillis());
            register.setLastAlertTimeout(l);
            this.fireAlert(register, n4, string2, string3, string);
        }
    }

    public abstract String getDescription();

    private void fireAlert(Register register, int n, String string, String string2, String string3) {
        int n2 = register.getLastAlertLevel();
        int n3 = register.getLastThresholdLevel();
        String string4 = String.valueOf(register.getThreshold(n3));
        String string5 = String.valueOf(register.getAlertTimeout(register.getLastAlertLevel()) / 1000L);
        if (string4.equals("-1.0")) {
            string4 = "-";
        }
        if (n2 == 0) {
            string5 = "0";
        }
        Alert alert = new Alert(n2, n, n3, string, string4, string2, string3, string5, register.getInitialAlertTime());
        this._alerterQueue.add(alert);
        this._logger.write(this.toString(), 5, "Fired alert for source:" + string + " at alert level:" + Alert.alertLevels[n2] + " on:" + string3 + " for threshold level:" + Alert.thresholdLevels[n3] + " at:" + string2 + " exceeding threshold of:" + string4 + " next alert sent in:" + string5 + "secs");
    }

    protected abstract Queue getQueue();

    protected int getQueueId() {
        if (this._qID == -1) {
            this._qID = this.getQueue().getQueue();
            this._logger.write(this.toString(), 5, "Assigned Queue - " + this._qID);
        }
        return this._qID;
    }
}

