/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import java.util.LinkedList;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.client.ClientMain;
import uk.org.iscream.cms.server.client.PluginMonitor;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.InvalidXMLException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;
import uk.org.iscream.cms.server.util.XMLPacket;
import uk.org.iscream.cms.server.util.XMLPacketMaker;

public class MonitorManager
extends Thread {
    public static final String REVISION = "$Revision: 1.14 $";
    private String _name = "LocalClient";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();
    private Queue _queue;
    private int _qID;
    private final String _suffix = "__Monitor";
    private LinkedList _monitorPipeline = new LinkedList();
    private Queue _dataQueue;
    private Queue _heartbeatQueue;
    private Queue _otherQueue;
    private Queue _allQueue;
    private static MonitorManager _instance;

    public static synchronized MonitorManager getInstance() {
        if (_instance == null) {
            _instance = new MonitorManager();
        }
        return _instance;
    }

    private MonitorManager() {
        String string;
        String string2;
        int n;
        this.setName("client.MonitorManager");
        this._queue = ClientMain._monitorQueue;
        this._qID = this._queue.getQueue();
        this._logger.write(this.toString(), 4, "Initialising");
        this._logger.write(this.toString(), 3, "Creating monitor pipeline for plugin monitors ...");
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        try {
            n = Integer.parseInt(configurationProxy.getProperty(this._name, "Queue.SizeLimit"));
            string2 = configurationProxy.getProperty(this._name, "Queue.RemoveAlgorithm");
            int n2 = StringUtils.getStringPos(string2, Queue.algorithms);
            if (n2 != -1) {
                this._logger.write(this.toString(), 5, "Starting 4 Queues with size limit of " + n + ", using remove algorithm " + string2);
                this._dataQueue = new Queue(n, n2);
                this._heartbeatQueue = new Queue(n, n2);
                this._otherQueue = new Queue(n, n2);
                this._allQueue = new Queue(n, n2);
            } else {
                this._logger.write(this.toString(), 2, "Bad Queue Algorithm configuration, not known: " + string2);
                this._dataQueue = new Queue();
                this._heartbeatQueue = new Queue();
                this._otherQueue = new Queue();
                this._allQueue = new Queue();
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 5, "Optional config not set: " + propertyNotFoundException);
            this._dataQueue = new Queue();
            this._heartbeatQueue = new Queue();
            this._otherQueue = new Queue();
            this._allQueue = new Queue();
        }
        catch (NumberFormatException numberFormatException) {
            this._logger.write(this.toString(), 2, "Bad Queue SizeLimit configuration: " + numberFormatException);
            this._dataQueue = new Queue();
            this._heartbeatQueue = new Queue();
            this._otherQueue = new Queue();
            this._allQueue = new Queue();
        }
        try {
            n = Integer.parseInt(configurationProxy.getProperty(this._name, "Queue.MonitorInterval"));
            this._dataQueue.startMonitor(n * 1000, ClientMain._monitorQueue, this._name + " DataQueue");
            this._heartbeatQueue.startMonitor(n * 1000, ClientMain._monitorQueue, this._name + " HeartbeatQueue");
            this._otherQueue.startMonitor(n * 1000, ClientMain._monitorQueue, this._name + " OtherQueue");
            this._allQueue.startMonitor(n * 1000, ClientMain._monitorQueue, this._name + " AllQueue");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "failed to find queue monitor config, disabling. " + propertyNotFoundException);
        }
        try {
            string = configurationProxy.getProperty(this._name, "Monitor.PluginsPackage");
            string2 = configurationProxy.getProperty(this._name, "Monitor.Plugins");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this._logger.write(this.toString(), 2, "Unable to get required configuration, Monitor's will not be activated: " + propertyNotFoundException);
            string = "";
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = string + "." + stringTokenizer.nextToken() + "__Monitor";
            this._logger.write(this.toString(), 5, "Attempting to create plugin: " + string3);
            try {
                PluginMonitor pluginMonitor = (PluginMonitor)ClassLoader.getSystemClassLoader().loadClass(string3).newInstance();
                this._monitorPipeline.add(pluginMonitor);
                this._logger.write(this.toString(), 5, "Added monitor: " + string3 + " (" + pluginMonitor.getDescription() + ")");
            }
            catch (InstantiationException instantiationException) {
                this._logger.write(this.toString(), 1, "Failed to instantiate " + string3 + " to the plugin monitor pipeline.");
                this._logger.write(this.toString(), 1, instantiationException.getMessage());
            }
            catch (Exception exception) {
                this._logger.write(this.toString(), 1, "Failed to add " + string3 + " to the plugin monitor pipeline.");
                this._logger.write(this.toString(), 1, exception.toString());
            }
        }
        this._logger.write(this.toString(), 3, "The monitor pipeline has been set up with " + this._monitorPipeline.size() + " plugin monitors.");
    }

    public void run() {
        XMLPacketMaker xMLPacketMaker = new XMLPacketMaker();
        boolean bl = true;
        String string = null;
        while (bl) {
            try {
                string = (String)this._queue.get(this._qID);
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Queue failure: " + invalidQueueException);
            }
            XMLPacket xMLPacket = null;
            try {
                xMLPacket = xMLPacketMaker.createXMLPacket(string);
            }
            catch (InvalidXMLException invalidXMLException) {
                this._logger.write(this.toString(), 1, "Invalid XML: " + invalidXMLException);
                continue;
            }
            if (xMLPacket.getParam("packet.attributes.type").equals("data")) {
                this._dataQueue.add(xMLPacket);
            } else if (xMLPacket.getParam("packet.attributes.type").equals("heartbeat")) {
                this._heartbeatQueue.add(xMLPacket);
            } else {
                this._otherQueue.add(xMLPacket);
            }
            this._allQueue.add(xMLPacket);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }

    public Queue getDataQueue() {
        return this._dataQueue;
    }

    public Queue getHeartbeatQueue() {
        return this._heartbeatQueue;
    }

    public Queue getOtherQueue() {
        return this._otherQueue;
    }

    public Queue getAllQueue() {
        return this._allQueue;
    }
}

