/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.client;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import uk.org.iscream.cms.server.client.Alert;
import uk.org.iscream.cms.server.client.AlerterManager;
import uk.org.iscream.cms.server.client.PluginAlerter;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.util.DateUtils;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public abstract class AlerterSkeleton
extends Thread
implements PluginAlerter {
    public final String REVISION = "$Revision: 1.9 $";
    public final String DEFAULT_LEVEL = Alert.alertLevels[0];
    public final String NOT_CONFIGURED = "<NOT CONFIGURED>";
    protected String _name = "AlerterSkeleton";
    protected Logger _logger = ReferenceManager.getInstance().getLogger();
    protected ConfigurationProxy _cp = ConfigurationProxy.getInstance();
    protected int _qID = -1;
    protected boolean _running = true;

    public AlerterSkeleton() {
        this._logger.write(this.toString(), 4, "started.");
        this.start();
    }

    public void run() {
        while (this._running) {
            try {
                String string;
                Alert alert = (Alert)this.getQueue().get(this.getQueueId());
                try {
                    string = this._cp.getProperty(this._name, "Alerter." + this.getFName() + ".level");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    string = this.DEFAULT_LEVEL;
                    this._logger.write(this.toString(), 2, "Alerter." + this.getFName() + ".level value unavailable using default of " + string);
                }
                int n = StringUtils.getStringPos(string, Alert.alertLevels);
                if ((alert.getLevel() != 0 || alert.getLastLevel() < n) && alert.getLevel() < n) continue;
                this.sendAlert(alert);
            }
            catch (InvalidQueueException invalidQueueException) {
                this._logger.write(this.toString(), 1, "Unable to get queue.");
            }
        }
    }

    protected abstract void sendAlert(Alert var1);

    protected String processAlertMessage(String string, Alert alert) {
        String string2 = Alert.alertLevels[alert.getLevel()];
        String string3 = Alert.thresholdLevels[alert.getThreshold()];
        String string4 = DateUtils.formatTime((System.currentTimeMillis() - alert.getInitialAlertTime()) / 1000L, "%DAYS% days, %HOURS% hours, %MINS% mins, and %SECS% secs");
        String string5 = DateFormat.getDateTimeInstance(3, 3, Locale.UK).format(new Date(alert.getInitialAlertTime()));
        string = StringUtils.replaceText(string, "%level%", string2);
        string = StringUtils.replaceText(string, "%threshold%", string3);
        string = StringUtils.replaceText(string, "%source%", alert.getSource());
        string = StringUtils.replaceText(string, "%value%", alert.getValue());
        string = StringUtils.replaceText(string, "%thresholdValue%", alert.getThresholdValue());
        string = StringUtils.replaceText(string, "%attributeName%", alert.getAttributeName());
        string = StringUtils.replaceText(string, "%timeTillNextAlert%", DateUtils.getTimeString(Long.parseLong(alert.getTimeTillNextAlert())));
        string = StringUtils.replaceText(string, "%timeSinceFirstAlert%", string4);
        string = StringUtils.replaceText(string, "%timeOfFirstAlert%", string5);
        return string;
    }

    public abstract String getDescription();

    protected Queue getQueue() {
        return AlerterManager.getInstance().getQueue();
    }

    protected int getQueueId() {
        if (this._qID == -1) {
            this._qID = this.getQueue().getQueue();
            this._logger.write(this.toString(), 5, "Assigned Queue - " + this._qID);
        }
        return this._qID;
    }

    protected abstract String getFName();
}

