/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.jacorb.util.Debug;

public class PopupMenuActivator
extends MouseAdapter {
    private JPopupMenu thePopupMenu;
    private JTree theTree;
    private JMenuItem[] theSelectionDependantMenuItems;
    private boolean theItemsEnabled = false;

    public PopupMenuActivator(JPopupMenu jPopupMenu, JTree jTree) {
        this(jPopupMenu, jTree, null);
    }

    public PopupMenuActivator(JPopupMenu jPopupMenu, JTree jTree, JMenuItem[] jMenuItemArray) {
        Debug.assert(1, jPopupMenu != null, "PopupMenuActivator.init: menu is null");
        this.thePopupMenu = jPopupMenu;
        Debug.assert(1, jTree != null, "PopupMenuActivator.init: tree is null");
        this.theTree = jTree;
        this.theSelectionDependantMenuItems = jMenuItemArray;
        if (this.theSelectionDependantMenuItems != null) {
            int n = 0;
            while (n < this.theSelectionDependantMenuItems.length) {
                this.theSelectionDependantMenuItems[n].setEnabled(true);
                ++n;
            }
            this.theItemsEnabled = true;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.theTree.getSelectionCount() > 0) {
            JMenuItem jMenuItem = (JMenuItem)this.thePopupMenu.getComponent(0);
            jMenuItem.doClick();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mayBeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mayBeShowPopup(mouseEvent);
    }

    private void mayBeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (this.theTree.getSelectionCount() > 0) {
                this.enableMenuItems();
            } else {
                this.disableMenuItems();
            }
            this.thePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void enableMenuItems() {
        if (this.theItemsEnabled) {
            return;
        }
        if (this.theSelectionDependantMenuItems == null) {
            return;
        }
        int n = 0;
        while (n < this.theSelectionDependantMenuItems.length) {
            this.theSelectionDependantMenuItems[n].setEnabled(true);
            ++n;
        }
        this.theItemsEnabled = true;
    }

    private void disableMenuItems() {
        if (!this.theItemsEnabled) {
            return;
        }
        if (this.theSelectionDependantMenuItems == null) {
            return;
        }
        int n = 0;
        while (n < this.theSelectionDependantMenuItems.length) {
            this.theSelectionDependantMenuItems[n].setEnabled(false);
            ++n;
        }
        this.theItemsEnabled = false;
    }
}

