/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.util;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.QueueMonitor;

public class Queue {
    public static final String REVISION = "$Revision: 1.22 $";
    public static final int RANDOM = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    public static final int DROP = 3;
    public static final String[] algorithms = new String[]{"RANDOM", "FIRST", "LAST", "DROP"};
    private LinkedList _lists = new LinkedList();
    private int _count = 0;
    private QueueMonitor _queueMon = null;
    private int _maxSize = -1;
    private int _removeAlgorithm = -1;
    private String _name = null;

    public Queue(int n, int n2) {
        this._maxSize = n;
        this._removeAlgorithm = n2;
    }

    public Queue() {
        this._maxSize = -1;
    }

    public void add(Object object) {
        int n = 0;
        while (n < this._lists.size()) {
            if (this._lists.get(n) != null) {
                LinkedList linkedList = (LinkedList)this._lists.get(n);
                synchronized (linkedList) {
                    int n2 = ((LinkedList)this._lists.get(n)).size();
                    if (this._maxSize != -1 && n2 >= this._maxSize && this._removeAlgorithm != 3) {
                        this.removeQueueItem((LinkedList)this._lists.get(n));
                    }
                    if (n2 < this._maxSize || this._removeAlgorithm != 3) {
                        Queue queue = this;
                        synchronized (queue) {
                            ((LinkedList)this._lists.get(n)).addLast(object);
                        }
                        ((LinkedList)this._lists.get(n)).notifyAll();
                    }
                }
            }
            ++n;
        }
        ++this._count;
    }

    public Object get(int n) throws InvalidQueueException {
        if (n >= this._lists.size() || this._lists.get(n) == null) {
            throw new InvalidQueueException("Requested queue " + n + " does not exist");
        }
        LinkedList linkedList = (LinkedList)this._lists.get(n);
        synchronized (linkedList) {
            if (((LinkedList)this._lists.get(n)).size() == 0) {
                try {
                    ((LinkedList)this._lists.get(n)).wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Object var3_4 = null;
        Queue queue = this;
        synchronized (queue) {
            try {
                var3_4 = ((LinkedList)this._lists.get(n)).removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return var3_4;
    }

    public void releaseQueue(int n) {
        LinkedList linkedList = (LinkedList)this._lists.get(n);
        synchronized (linkedList) {
            ((LinkedList)this._lists.get(n)).notifyAll();
        }
    }

    public void clearQueue(int n) {
        Queue queue = this;
        synchronized (queue) {
            ((LinkedList)this._lists.get(n)).clear();
        }
    }

    public String xmlStatus() {
        String string = "<queue ";
        int n = 0;
        while (n < this._lists.size()) {
            string = this._lists.get(n) != null ? string + "queue" + n + "=\"" + ((LinkedList)this._lists.get(n)).size() + "\" " : string + "queue" + n + "=\"[deleted]\" ";
            ++n;
        }
        string = string + "total=\"" + this._count + "\"";
        if (this._maxSize != -1) {
            string = string + " maxSize=\"" + this._maxSize + "\"";
        }
        string = string + "></queue>";
        return string;
    }

    public int queueSize(int n) throws InvalidQueueException {
        if (n >= this._lists.size() || this._lists.get(n) == null) {
            throw new InvalidQueueException("Requested queue " + n + " does not exist");
        }
        return ((LinkedList)this._lists.get(n)).size();
    }

    public int elementCount() {
        return this._count;
    }

    public synchronized int getQueue() {
        int n = -1;
        int n2 = 0;
        while (n2 < this._lists.size()) {
            if (this._lists.get(n2) == null) {
                n = n2;
                this._lists.set(n2, new LinkedList());
            }
            ++n2;
        }
        if (n == -1) {
            n = this._lists.size();
            this._lists.add(n, new LinkedList());
        }
        return n;
    }

    public synchronized void removeQueue(int n) {
        this._lists.set(n, null);
    }

    public boolean startMonitor(long l, Queue queue, String string) {
        if (this._queueMon == null) {
            this._queueMon = new QueueMonitor(this, queue, l, string);
            this._queueMon.start();
            return true;
        }
        return false;
    }

    public boolean startMonitor(long l, String string) {
        return this.startMonitor(l, this, string);
    }

    public boolean stopMonitor() {
        if (this._queueMon != null) {
            this._queueMon.shutdown();
            this._queueMon = null;
            return true;
        }
        return false;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }

    private void removeQueueItem(LinkedList linkedList) {
        if (this._removeAlgorithm == 0) {
            Random random = new Random(System.currentTimeMillis());
            int n = random.nextInt(this._maxSize);
            Queue queue = this;
            synchronized (queue) {
                linkedList.remove(n);
            }
        }
        if (this._removeAlgorithm == 1) {
            Queue queue = this;
            synchronized (queue) {
                linkedList.removeFirst();
            }
        }
        if (this._removeAlgorithm == 2) {
            Queue queue = this;
            synchronized (queue) {
                linkedList.removeLast();
            }
        }
    }
}

