/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.dbreporter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import uk.org.iscream.cms.dbreporter.Report;

public class ReportList {
    public final String REVISION = "$Revision: 1.13 $";
    private LinkedList _reports = new LinkedList();

    public ReportList(String string) throws IOException {
        this.readFile(string);
    }

    public String toString() {
        return this.getClass().getName() + "(" + "$Revision: 1.13 $".substring(11, "$Revision: 1.13 $".length() - 2) + ")";
    }

    public Iterator iterator() {
        return this._reports.iterator();
    }

    public int size() {
        return this._reports.size();
    }

    private void readFile(String string) throws IOException {
        String string2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            int n = 0;
            while (string2 != null) {
                ++n;
                if ((string2 = string2.trim()).equals("")) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.substring(0, 1).equals("#")) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                Report report = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                if (stringTokenizer.countTokens() == 2) {
                    report = new Report(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                } else if (stringTokenizer.countTokens() == 3) {
                    try {
                        report = new Report(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Line " + n + "of the report skipped: " + numberFormatException);
                    }
                } else {
                    System.out.println("Line " + n + " of the report was skipped: " + string2);
                    string2 = bufferedReader.readLine();
                    continue;
                }
                this._reports.add(report);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Could not read the list of reports to run from " + string + ": " + iOException);
        }
    }
}

