/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.dbreporter;

import java.util.Iterator;
import java.util.LinkedList;
import uk.org.iscream.cms.dbreporter.PairData;

public class PlotData {
    public final String REVISION = "$Revision: 1.18 $";
    private LinkedList _data = new LinkedList();
    private double _maxY;
    private double _minY = 0.0;
    private double _minX;
    private double _maxX;
    private int _lastX = -1;
    private int _cumulativeCount = 0;
    private double _cumulativeValue = 0.0;
    private double _lastDoubleX = 0.0;

    public PlotData(long l, long l2) {
        this._minX = l;
        this._maxX = l2;
    }

    public double getMaxY() {
        return this._maxY;
    }

    public Iterator iterator() {
        return this._data.iterator();
    }

    public long countPoints() {
        return this._data.size();
    }

    public void addPoint(long l, long l2) {
        this.addPoint((double)l, (double)l2);
    }

    public void addPoint(long l, double d) {
        this.addPoint((double)l, d);
    }

    public void addPoint(double d, double d2) {
        int n = (int)((d - this._minX) / (this._maxX - this._minX) * 500.0);
        if (n == this._lastX) {
            this._cumulativeValue += d2;
            ++this._cumulativeCount;
            this._lastX = n;
            return;
        }
        if (this._cumulativeCount == 0) {
            this._cumulativeValue = d2;
            this._cumulativeCount = 1;
            this._lastX = n;
            return;
        }
        double d3 = d2;
        d2 = this._cumulativeValue / (double)this._cumulativeCount;
        this._cumulativeCount = 1;
        this._cumulativeValue = d3;
        PairData pairData = new PairData(this._lastDoubleX, d2);
        this._data.add(pairData);
        if (this._data.size() == 1) {
            this._maxY = d2;
        }
        if (d2 > this._maxY) {
            this._maxY = d2;
        }
        this._lastDoubleX = d;
        this._lastX = n;
    }

    public void flushPoints() {
        if (this._cumulativeCount > 0) {
            this.addPoint(2.0 * this._maxX, 0.0);
        }
    }

    public void scaleToFitX(int n, int n2) {
        Iterator iterator = this._data.iterator();
        while (iterator.hasNext()) {
            PairData pairData = (PairData)iterator.next();
            double d = pairData.getX();
            double d2 = pairData.getY();
            d = (d - this._minX) / (this._maxX - this._minX) * (double)n;
            pairData.setPair(d, d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + "$Revision: 1.18 $".substring(11, "$Revision: 1.18 $".length() - 2) + ")";
    }
}

