/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.dbreporter;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class DBReporterSettings {
    public final String REVISION = "$Revision: 1.3 $";
    private String _dbConnectionString;
    private String _mySQLDriverName;
    private String _reportList;
    private String _outputDirectory;
    private int _reportDayOffset;
    private int _deleteDayOffset;

    public String getConnectionString() {
        return this._dbConnectionString;
    }

    public String getDriverName() {
        return this._mySQLDriverName;
    }

    public String getReportList() {
        return this._reportList;
    }

    public String getOutputDirectory() {
        return this._outputDirectory;
    }

    public int getReportDayOffset() {
        return this._reportDayOffset;
    }

    public int getDeleteDayOffset() {
        return this._deleteDayOffset;
    }

    public String toString() {
        return this.getClass().getName() + "(" + "$Revision: 1.3 $".substring(11, "$Revision: 1.3 $".length() - 2) + ")";
    }

    public boolean obtainSettings(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            return false;
        }
        this._dbConnectionString = properties.getProperty("DatabaseConnectionString");
        if (this._dbConnectionString == null) {
            return false;
        }
        this._mySQLDriverName = properties.getProperty("MySQLDriverName");
        if (this._mySQLDriverName == null) {
            return false;
        }
        this._reportList = properties.getProperty("ReportList");
        if (this._reportList == null) {
            return false;
        }
        this._outputDirectory = properties.getProperty("OutputDirectory");
        if (this._outputDirectory == null) {
            return false;
        }
        try {
            this._reportDayOffset = Integer.parseInt(properties.getProperty("ReportDayOffset", "0"));
            this._deleteDayOffset = Integer.parseInt(properties.getProperty("DeleteDayOffset", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

