/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.dbreporter;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import uk.org.iscream.cms.dbreporter.DBReporter;
import uk.org.iscream.cms.dbreporter.DBReporterSettings;
import uk.org.iscream.cms.dbreporter.ReportList;
import uk.org.iscream.cms.server.util.DateUtils;

public class DBReporterMain {
    public final String REVISION = "$Revision: 1.33 $";

    public static void main(String[] stringArray) {
        DBReporterSettings dBReporterSettings;
        if (stringArray.length != 1) {
            System.out.println("Typical usage: java DBReporterMain DBReporter.properties");
            System.exit(33);
        }
        if (!(dBReporterSettings = new DBReporterSettings()).obtainSettings(stringArray[0])) {
            System.out.println("Could not obtain the settings from " + stringArray[0]);
            System.out.println("Please read your i-scream DBReporter documentation.");
            System.exit(0);
        }
        String string = dBReporterSettings.getReportList();
        String string2 = dBReporterSettings.getOutputDirectory();
        int n = dBReporterSettings.getReportDayOffset();
        int n2 = dBReporterSettings.getDeleteDayOffset();
        File file = new File(string2);
        if (!file.isDirectory()) {
            System.out.println(string2 + " is not a directory.");
            return;
        }
        long l = DateUtils.startOfToday();
        l = DateUtils.subtractDays((long)l, (int)n);
        long l2 = DateUtils.subtractDays((long)l, (int)1);
        System.out.println("Generating reports for " + DateUtils.shortDateString((long)l2));
        DBReporter dBReporter = new DBReporter(l2, l, n2, dBReporterSettings);
        ReportList reportList = null;
        try {
            reportList = new ReportList(string);
        }
        catch (IOException iOException) {
            System.out.println("Could not run all the reports: " + iOException);
            return;
        }
        try {
            dBReporter.runReports(reportList, string2);
        }
        catch (SQLException sQLException) {
            System.out.println("Fatal SQL errors - Cannot complete reports: " + sQLException);
        }
        catch (Exception exception) {
            System.out.println("Fatal errors - Cannot complete reports: " + exception);
        }
        System.out.println("DBReporterMain finished.");
    }
}

