/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.dbreporter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import uk.org.iscream.cms.dbreporter.DBReporterSettings;
import uk.org.iscream.cms.dbreporter.DatabaseRemover;
import uk.org.iscream.cms.dbreporter.IscreamFilePlacer;
import uk.org.iscream.cms.dbreporter.Report;
import uk.org.iscream.cms.dbreporter.ReportList;
import uk.org.iscream.cms.dbreporter.ReportMaker;
import uk.org.iscream.cms.server.util.DateUtils;

public class DBReporter {
    public final String REVISION = "$Revision: 1.28 $";
    private long _startTime;
    private long _endTime;
    private int _olderThanDays;
    private DBReporterSettings _settings = null;
    private Connection _conn = null;
    private Statement _stmt = null;

    public DBReporter(long l, long l2, int n, DBReporterSettings dBReporterSettings) {
        this._startTime = l;
        this._endTime = l2;
        this._olderThanDays = n;
        this._settings = dBReporterSettings;
    }

    public void runReports(ReportList reportList, String string) throws SQLException, Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.out.println("Preparing reports ...");
        try {
            Class.forName(this._settings.getDriverName()).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Could not find the MySQL driver: " + exception);
        }
        try {
            this._conn = DriverManager.getConnection(this._settings.getConnectionString());
            this._stmt = this._conn.createStatement();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Could not connect to the database: " + sQLException);
        }
        try {
            this._stmt.executeUpdate("SET SQL_BIG_TABLES = 1;");
        }
        catch (SQLException sQLException) {
            System.out.println("WARNING: Could not set MySQL to write temporary tables to disk.");
            System.out.println("Some of the following i-scream reports may fail if there is insufficient memory.");
        }
        LinkedList linkedList = this.getDistinctMachines();
        System.out.println("Readying reports for " + linkedList.size() + " machines.");
        ReportMaker reportMaker = new ReportMaker(this._stmt, string, DateUtils.shortDateString((long)this._startTime), this._startTime, this._endTime);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            reportMaker.produce(reportList, (String)object4);
        }
        object4 = new IscreamFilePlacer(string);
        File file = ((IscreamFilePlacer)object4).makeDir(DateUtils.shortDateString((long)this._startTime));
        System.out.println("Writing report.inc");
        File file2 = new File(file, "report.inc");
        try {
            object3 = new BufferedWriter(new FileWriter(file2));
            object2 = reportList.iterator();
            while (object2.hasNext()) {
                object = (Report)object2.next();
                ((Writer)object3).write("<option value=\"" + ((Report)object).getReportField() + "\">" + ((Report)object).getFriendlyName() + "</option>");
            }
            ((BufferedWriter)object3).flush();
            ((BufferedWriter)object3).close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to create" + file2);
        }
        System.out.println("Writing machine_name.inc");
        object3 = new File(file, "machine_name.inc");
        try {
            object2 = new BufferedWriter(new FileWriter((File)object3));
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                ((Writer)object2).write("<option value=\"" + (String)object + "\">" + (String)object + "</option>");
            }
            ((BufferedWriter)object2).flush();
            ((BufferedWriter)object2).close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to create" + object3);
        }
        System.out.println("Writing day.inc");
        object2 = new File(new File(string), "day.inc");
        try {
            object = new BufferedWriter(new FileWriter((File)object2));
            ((Writer)object).write("<? $day = \"" + DateUtils.shortDateString((long)this._startTime) + "\"; ?>");
            ((BufferedWriter)object).flush();
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to create" + object2);
        }
        if (this._olderThanDays > 0) {
            System.out.println("Removing entries older than " + DateUtils.shortDateString((long)this._startTime) + " from the database ...");
            object = new DatabaseRemover(this._stmt, "ipacket", "receipt_date");
            ((DatabaseRemover)object).removeOlderThan(DateUtils.subtractDays((long)this._endTime, (int)this._olderThanDays));
        }
    }

    private LinkedList getDistinctMachines() throws SQLException {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            ResultSet resultSet = this._stmt.executeQuery("SELECT DISTINCT machine_name from ipacket WHERE receipt_date >= " + this._startTime + " AND receipt_date <= " + this._endTime + ";");
            while (resultSet.next()) {
                String string = resultSet.getString("machine_name");
                linkedList.add(string);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Unable to find distinct machine names: " + sQLException);
        }
        return linkedList;
    }
}

