/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ukc.iscream.corbaservices;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;

public class MiniWebServer
extends Thread {
    public static final String REVISION = "$Revision: 1.4 $";
    private int _port;
    private LinkedList _okUrls;
    private String _okUrlsConfig;
    private long _okUrlsConfigStamp = 0L;
    private String _webDir;

    public MiniWebServer(int n, String string, String string2) {
        this._port = n;
        this._okUrlsConfig = string;
        this._webDir = string2;
    }

    public void run() {
        block4: while (true) {
            boolean bl = true;
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this._port);
            }
            catch (IOException iOException) {
                bl = false;
                System.out.println(iOException);
                iOException.printStackTrace();
            }
            while (true) {
                if (!bl) continue block4;
                try {
                    Socket socket = serverSocket.accept();
                    Handler handler = new Handler(socket);
                    handler.start();
                }
                catch (IOException iOException) {
                    bl = false;
                    System.out.println(iOException);
                    iOException.printStackTrace();
                }
            }
            break;
        }
    }

    private String readUrl(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            File file = new File(this._webDir + "/" + string);
            if (file.exists() && file.canRead()) {
                String string2 = "";
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while (bufferedReader.ready()) {
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) continue;
                    string2 = string2 + string3 + "\n";
                }
                return string2;
            }
            return null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    private boolean okUrl(String string) {
        this.readOkUrls();
        Iterator iterator = this._okUrls.iterator();
        while (iterator.hasNext()) {
            if (!string.equals((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void readOkUrls() {
        File file = new File(this._okUrlsConfig);
        long l = file.lastModified();
        if (l > this._okUrlsConfigStamp) {
            this._okUrlsConfigStamp = l;
            this._okUrls = new LinkedList();
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    while (bufferedReader.ready()) {
                        String string = bufferedReader.readLine();
                        if (string.startsWith("#")) continue;
                        this._okUrls.add(string);
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                    iOException.printStackTrace();
                }
            }
        }
    }

    private class Handler
    extends Thread {
        private Socket _socket;

        public Handler(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            BufferedReader bufferedReader = null;
            PrintWriter printWriter = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
                printWriter = new PrintWriter(this._socket.getOutputStream(), true);
                String string = "";
                String string2 = "";
                do {
                    if (!(string = bufferedReader.readLine()).startsWith("GET")) continue;
                    string2 = string.substring(4);
                    string2 = string2.substring(0, string2.lastIndexOf(32));
                } while (!string.equals(""));
                if (MiniWebServer.this.okUrl(string2)) {
                    String string3 = MiniWebServer.this.readUrl(string2);
                    if (string3 != null) {
                        printWriter.println(string3);
                    } else {
                        printWriter.println("HTTP/1.1 404 Not Found\n");
                        printWriter.println("404 Not Found");
                    }
                } else {
                    printWriter.println("HTTP/1.1 403 Permission Denied\n");
                    printWriter.println("403 Permission Denied");
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
            try {
                bufferedReader.close();
                printWriter.close();
                this._socket.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
        }
    }
}

