/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.jacorb.transaction.CoordinatorImpl;
import org.jacorb.transaction.Timer;
import org.jacorb.util.Debug;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TransactionService
extends TransactionFactoryPOA {
    private static boolean initialized = false;
    private static TransactionService factory;
    private static TransactionFactory fact_ref;
    private static CoordinatorImpl[] coordinators;
    private static Timer timer;
    private static int trans_id;
    private static POA poa;

    static Timer get_timer() {
        return timer;
    }

    public static boolean is_initialized() {
        return initialized;
    }

    public static TransactionFactory get_reference() {
        return fact_ref;
    }

    static void release_coordinator(int n) {
        TransactionService.coordinators[n] = null;
    }

    private int find_free() {
        int n = 0;
        while (n < coordinators.length) {
            if (coordinators[n] == null) {
                return n;
            }
            ++n;
        }
        throw new INTERNAL();
    }

    public Control create(int n) {
        int n2;
        ++trans_id;
        CoordinatorImpl[] coordinatorImplArray = coordinators;
        synchronized (coordinatorImplArray) {
            n2 = this.find_free();
            TransactionService.coordinators[n2] = new CoordinatorImpl(poa, trans_id, n2, n);
        }
        return coordinators[n2]._get_control();
    }

    public Control recreate(PropagationContext propagationContext) {
        throw new NO_IMPLEMENT();
    }

    public static void start(POA pOA, int n) {
        if (initialized) {
            throw new INTERNAL();
        }
        try {
            poa = pOA;
            factory = new TransactionService();
            fact_ref = TransactionFactoryHelper.narrow(poa.servant_to_reference(factory));
            coordinators = new CoordinatorImpl[n];
            int n2 = 0;
            while (n2 < coordinators.length) {
                TransactionService.coordinators[n2] = null;
                ++n2;
            }
            timer = new Timer(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        initialized = true;
        Debug.output(1, "TransactionService up");
    }

    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        try {
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            TransactionService transactionService = new TransactionService();
            TransactionService.start(pOA, 10);
            if (stringArray.length == 1) {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(stringArray[0])));
                printWriter.println(oRB.object_to_string(TransactionService.get_reference()));
                printWriter.close();
            } else {
                NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
                NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("TransactionService", "service")};
                namingContextExt.bind(nameComponentArray, TransactionService.get_reference());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        oRB.run();
    }

    static {
        trans_id = 0;
    }
}

