/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.util.Hashtable;
import org.jacorb.orb.LocalityConstrainedObject;
import org.jacorb.orb.ORB;
import org.jacorb.transaction.ServerInitializer;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.otid_t;

public class TransactionCurrentImpl
extends LocalityConstrainedObject
implements Current {
    private static final int DEFAULT_TIMEOUT = 30;
    private Hashtable contexts = null;
    private Hashtable timeouts = null;
    private ORB orb = null;
    private int slot_id = -1;
    private TransactionFactory factory = null;

    public TransactionCurrentImpl(ORB oRB, int n) {
        this.orb = oRB;
        this.slot_id = n;
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
        try {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("TransactionService", "service")};
            this.factory = TransactionFactoryHelper.narrow(namingContextExt.resolve(nameComponentArray));
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }

    public TransactionCurrentImpl() {
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
    }

    public static Control getControl(org.omg.CORBA.ORB oRB) {
        try {
            org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)oRB.resolve_initial_references("PICurrent");
            PropagationContext propagationContext = PropagationContextHelper.extract(current.get_slot(ServerInitializer.slot_id));
            return ControlHelper.extract(propagationContext.implementation_specific_data);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            return null;
        }
    }

    public void begin() throws SubtransactionsUnavailable {
        Thread thread = Thread.currentThread();
        if (this.contexts.containsKey(thread)) {
            throw new SubtransactionsUnavailable();
        }
        int n = this.timeouts.containsKey(thread) ? (Integer)this.timeouts.get(thread) : 30;
        Control control = this.factory.create(n);
        this.contexts.put(thread, control);
        try {
            org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
            TransIdentity transIdentity = new TransIdentity(control.get_coordinator(), control.get_terminator(), new otid_t(0, 0, new byte[0]));
            Any any = this.orb.create_any();
            ControlHelper.insert(any, control);
            PropagationContext propagationContext = new PropagationContext(n, transIdentity, new TransIdentity[0], any);
            Any any2 = this.orb.create_any();
            PropagationContextHelper.insert(any2, propagationContext);
            current.set_slot(this.slot_id, any2);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }

    public void commit(boolean bl) throws NoTransaction, HeuristicMixed, HeuristicHazard {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            throw new NoTransaction();
        }
        try {
            Control control = (Control)this.contexts.get(thread);
            control.get_terminator().commit(bl);
            control._release();
            this.removeContext(thread);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }

    public Control get_control() {
        return (Control)this.contexts.get(Thread.currentThread());
    }

    public Status get_status() {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(thread)).get_coordinator().get_status();
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            return null;
        }
    }

    public String get_transaction_name() {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(thread)).get_coordinator().get_transaction_name();
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            return null;
        }
    }

    public void resume(Control control) throws InvalidControl {
        throw new NO_IMPLEMENT();
    }

    public void rollback() throws NoTransaction {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            throw new NoTransaction();
        }
        try {
            Control control = (Control)this.contexts.get(thread);
            control.get_terminator().rollback();
            control._release();
            this.removeContext(thread);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }

    public void rollback_only() throws NoTransaction {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            throw new NoTransaction();
        }
        try {
            Control control = (Control)this.contexts.get(thread);
            control.get_coordinator().rollback_only();
            control._release();
            this.removeContext(thread);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }

    public void set_timeout(int n) {
        this.timeouts.put(Thread.currentThread(), new Integer(n));
    }

    public Control suspend() {
        throw new NO_IMPLEMENT();
    }

    private void removeContext(Thread thread) {
        this.contexts.remove(thread);
        try {
            org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
            Any any = this.orb.create_any();
            current.set_slot(this.slot_id, any);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
        }
    }
}

