/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

public class Lex {
    private StringBuffer m_input;
    private int m_token = 0;
    private StringBuffer m_buffer = new StringBuffer();
    private String m_lexeme = null;
    private int m_pos = 0;
    private Hashtable m_literals = new Hashtable();
    private boolean m_eof = false;
    public static final int ERROR = 0;
    public static final int END = 1;
    public static final int LPAREN = 2;
    public static final int RPAREN = 3;
    public static final int EXIST = 4;
    public static final int MINUS = 5;
    public static final int NOT = 6;
    public static final int MULT = 7;
    public static final int DIV = 8;
    public static final int PLUS = 9;
    public static final int TILDE = 10;
    public static final int IN = 11;
    public static final int EQUAL = 12;
    public static final int NOT_EQUAL = 13;
    public static final int LESS = 14;
    public static final int LESS_EQUAL = 15;
    public static final int GREATER = 16;
    public static final int GREATER_EQUAL = 17;
    public static final int AND = 18;
    public static final int OR = 19;
    public static final int IDENT = 20;
    public static final int TRUE_LIT = 21;
    public static final int FALSE_LIT = 22;
    public static final int STRING_LIT = 23;
    public static final int NUMBER_LIT = 24;
    public static final int PREF_MIN = 25;
    public static final int PREF_MAX = 26;
    public static final int PREF_WITH = 27;
    public static final int PREF_RANDOM = 28;
    public static final int PREF_FIRST = 29;

    private Lex() {
    }

    public Lex(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.m_input = new StringBuffer();
        boolean bl = false;
        char[] cArray = new char[512];
        while (!bl) {
            try {
                int n = bufferedReader.read(cArray);
                if (n < 0) {
                    bl = true;
                    continue;
                }
                this.m_input.append(cArray, 0, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_literals.put("TRUE", new Integer(21));
        this.m_literals.put("FALSE", new Integer(22));
        this.m_literals.put("and", new Integer(18));
        this.m_literals.put("not", new Integer(6));
        this.m_literals.put("or", new Integer(19));
        this.m_literals.put("exist", new Integer(4));
        this.m_literals.put("in", new Integer(11));
        this.m_literals.put("min", new Integer(25));
        this.m_literals.put("max", new Integer(26));
        this.m_literals.put("with", new Integer(27));
        this.m_literals.put("random", new Integer(28));
        this.m_literals.put("first", new Integer(29));
        this.nextToken();
    }

    /*
     * Unable to fully structure code
     */
    public void nextToken() {
        var1_1 = 0;
        var2_2 = false;
        this.clearLexeme();
        block21: while (!var2_2) {
            var3_3 = this.nextChar();
            if (this.eof()) {
                var1_1 = 1;
                break;
            }
            switch (var3_3) {
                case '(': {
                    var1_1 = 2;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case ')': {
                    var1_1 = 3;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '-': {
                    var1_1 = 5;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '*': {
                    var1_1 = 7;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '/': {
                    var1_1 = 8;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '+': {
                    var1_1 = 9;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '~': {
                    var1_1 = 10;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl148
                }
                case '=': {
                    var4_4 = this.nextChar();
                    if (var4_4 == '=') {
                        this.addLexeme(var3_3);
                        this.addLexeme(var4_4);
                        var1_1 = 12;
                    } else {
                        this.pushBack(var4_4);
                        var1_1 = 0;
                    }
                    var2_2 = true;
                    ** GOTO lbl148
                }
                case '!': {
                    var4_5 = this.nextChar();
                    if (var4_5 == '=') {
                        this.addLexeme(var3_3);
                        this.addLexeme(var4_5);
                        var1_1 = 13;
                    } else {
                        var1_1 = 0;
                    }
                    var2_2 = true;
                    ** GOTO lbl148
                }
                case '<': {
                    var4_6 = this.nextChar();
                    this.addLexeme(var3_3);
                    if (var4_6 == '=') {
                        this.addLexeme(var4_6);
                        var1_1 = 15;
                    } else {
                        this.pushBack(var4_6);
                        var1_1 = 14;
                    }
                    var2_2 = true;
                    ** GOTO lbl148
                }
                case '>': {
                    var4_7 = this.nextChar();
                    this.addLexeme(var3_3);
                    if (var4_7 == '=') {
                        this.addLexeme(var4_7);
                        var1_1 = 17;
                    } else {
                        this.pushBack(var4_7);
                        var1_1 = 16;
                    }
                    var2_2 = true;
                    ** GOTO lbl148
                }
                case '\'': {
                    var1_1 = 23;
                    while ((var3_3 = this.nextChar()) != '\'') {
                        if (var3_3 == '\n') {
                            var1_1 = 0;
                            break;
                        }
                        if (var3_3 == '\\') {
                            var3_3 = this.nextChar();
                        }
                        if (this.eof()) {
                            var1_1 = 0;
                            break;
                        }
                        this.addLexeme(var3_3);
                    }
                    var2_2 = true;
                    ** GOTO lbl148
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    var4_8 = false;
                    var5_10 = false;
                    var6_12 = false;
                    var7_13 = '\u0000';
                    while (!var2_2) {
                        switch (var3_3) {
                            case '.': {
                                if (var5_10) {
                                    var6_12 = true;
                                    var2_2 = true;
                                    break;
                                }
                                this.addLexeme(var3_3);
                                var5_10 = true;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                if (var4_8 || !Character.isDigit(var7_13)) {
                                    var6_12 = true;
                                    var2_2 = true;
                                    break;
                                }
                                var4_8 = true;
                                this.addLexeme(var3_3);
                                var3_3 = this.nextChar();
                                if (var3_3 == '+' || var3_3 == '-') {
                                    this.addLexeme(var3_3);
                                    break;
                                }
                                this.pushBack(var3_3);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.addLexeme(var3_3);
                                break;
                            }
                            default: {
                                this.pushBack(var3_3);
                                var2_2 = true;
                            }
                        }
                        if (var2_2) continue;
                        var7_13 = var3_3;
                        var3_3 = this.nextChar();
                        if (!this.eof()) continue;
                        var2_2 = true;
                    }
                    if (var6_12) ** GOTO lbl148
                    var1_1 = !Character.isDigit(var7_13) ? 0 : 24;
                    ** GOTO lbl148
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
lbl148:
                // 15 sources

                default: {
                    if (var2_2) continue block21;
                    if (var3_3 == '_' || Character.isLetter(var3_3)) ** GOTO lbl156
                    var1_1 = 0;
                    var2_2 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this.addLexeme(var3_3);
                        var3_3 = this.nextChar();
lbl156:
                        // 2 sources

                        ** while (this.isIdent((char)var3_3) && !this.eof())
                    }
lbl157:
                    // 1 sources

                    if (!this.eof()) {
                        this.pushBack(var3_3);
                    }
                    var1_1 = (var5_11 = (Integer)this.m_literals.get(var4_9 = this.getLexeme())) == null ? 20 : var5_11;
                    var2_2 = true;
                }
            }
        }
        this.m_token = var1_1;
    }

    public int getToken() {
        return this.m_token;
    }

    public String getLexeme() {
        if (this.m_lexeme == null) {
            this.m_lexeme = this.m_buffer.toString();
        }
        return this.m_lexeme;
    }

    public int getPosition() {
        return this.m_pos;
    }

    protected boolean eof() {
        return this.m_eof;
    }

    protected char nextChar() {
        char c = '\u0000';
        if (this.m_pos < this.m_input.length()) {
            c = this.m_input.charAt(this.m_pos);
            ++this.m_pos;
        } else {
            this.m_eof = true;
        }
        return c;
    }

    protected void pushBack(char c) {
        if (c != '\u0000') {
            --this.m_pos;
        }
    }

    protected boolean isIdent(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected void clearLexeme() {
        this.m_lexeme = null;
        this.m_buffer.setLength(0);
    }

    protected void addLexeme(char c) {
        this.m_buffer.append(c);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: Lex expr");
            System.exit(1);
        }
        Lex lex = new Lex(new StringReader(stringArray[0]));
        int n = lex.getToken();
        while (n != 1 && n != 0) {
            System.out.println("Token = '" + lex.getLexeme() + "' (" + Lex.tokenName(n) + ")");
            lex.nextToken();
            n = lex.getToken();
        }
        System.out.println("Token = " + Lex.tokenName(n));
    }

    protected static String tokenName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "ERROR";
                break;
            }
            case 1: {
                string = "END";
                break;
            }
            case 2: {
                string = "LPAREN";
                break;
            }
            case 3: {
                string = "RPAREN";
                break;
            }
            case 4: {
                string = "EXIST";
                break;
            }
            case 5: {
                string = "MINUS";
                break;
            }
            case 6: {
                string = "NOT";
                break;
            }
            case 7: {
                string = "MULT";
                break;
            }
            case 8: {
                string = "DIV";
                break;
            }
            case 9: {
                string = "PLUS";
                break;
            }
            case 10: {
                string = "TILDE";
                break;
            }
            case 11: {
                string = "IN";
                break;
            }
            case 12: {
                string = "EQUAL";
                break;
            }
            case 13: {
                string = "NOT_EQUAL";
                break;
            }
            case 14: {
                string = "LESS";
                break;
            }
            case 15: {
                string = "LESS_EQUAL";
                break;
            }
            case 16: {
                string = "GREATER";
                break;
            }
            case 17: {
                string = "GREATER_EQUAL";
                break;
            }
            case 18: {
                string = "AND";
                break;
            }
            case 19: {
                string = "OR";
                break;
            }
            case 20: {
                string = "IDENT";
                break;
            }
            case 21: {
                string = "TRUE_LIT";
                break;
            }
            case 22: {
                string = "FALSE_LIT";
                break;
            }
            case 23: {
                string = "STRING_LIT";
                break;
            }
            case 24: {
                string = "NUMBER_LIT";
                break;
            }
            case 25: {
                string = "PREF_MIN";
                break;
            }
            case 26: {
                string = "PREF_MAX";
                break;
            }
            case 27: {
                string = "PREF_WITH";
                break;
            }
            case 28: {
                string = "PREF_RANDOM";
                break;
            }
            case 29: {
                string = "PREF_FIRST";
                break;
            }
            default: {
                string = "<unknown>";
            }
        }
        return string;
    }
}

