/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.PortableServer.POAManagerPackage.State;

public class LogWriter
implements LogTrace {
    private LogTrace delegate;
    private String prefix;
    private boolean isSystemId;
    private boolean isLogFileOut;

    private LogWriter() {
    }

    public LogWriter(String string, boolean bl) {
        this.prefix = string + " - ";
        this.isSystemId = bl;
        if (Environment.logFileOut() != null) {
            this.isLogFileOut = true;
        }
    }

    public void printLog(int n, byte[] byArray, String string) {
        if (Environment.verbosityLevel() >= n) {
            this.printLog_(n, "oid: " + POAUtil.convert(byArray, this.isSystemId) + " - " + string);
        }
    }

    public void printLog(int n, ServerRequest serverRequest, String string) {
        if (Environment.verbosityLevel() >= n) {
            this.printLog_(n, "rid: " + serverRequest.requestId() + " oid: " + POAUtil.convert(serverRequest.objectId(), this.isSystemId) + " opname: " + serverRequest.operation() + " - " + string);
        }
    }

    public void printLog(int n, ServerRequest serverRequest, State state, String string) {
        if (Environment.verbosityLevel() >= n) {
            this.printLog_(n, "rid: " + serverRequest.requestId() + " oid: " + POAUtil.convert(serverRequest.objectId(), this.isSystemId) + " opname: " + serverRequest.operation() + " - " + string + " (in state " + POAUtil.convert(state) + ")");
        }
    }

    public void printLog(int n, String string) {
        if (Environment.verbosityLevel() >= n) {
            this.printLog_(n, string);
        }
    }

    public void printLog(int n, Throwable throwable) {
        if (Environment.verbosityLevel() >= n) {
            this.printLog_(n, throwable);
        }
    }

    private void printLog_(int n, String string) {
        if (this.isLogFileOut || this.delegate == null) {
            Debug.output(n, this.prefix + string);
        }
        if (this.delegate != null) {
            this.delegate.printLog(n, string);
        }
    }

    private void printLog_(int n, Throwable throwable) {
        if (this.isLogFileOut || this.delegate == null) {
            Debug.output(n, throwable);
        }
        if (this.delegate != null) {
            this.delegate.printLog(n, throwable);
        }
    }

    public void setLogTrace(LogTrace logTrace) {
        this.delegate = logTrace;
    }
}

