/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.policy;

import java.util.StringTokenizer;
import org.jacorb.orb.LocalityConstrainedObject;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.InitialMapToDefaultDomainPolicy;
import org.jacorb.orb.domain.InvalidName;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;

public class MapToDefaultDomainsPolicy
extends LocalityConstrainedObject
implements InitialMapToDefaultDomainPolicy {
    private Domain[] _default_domains;
    private String[] _default_pathnames;
    private String _pathnames;

    public MapToDefaultDomainsPolicy(String string) {
        this._pathnames = string;
        this._default_pathnames = this.createStringArrayFromString(string);
        Debug.output(32770, "MapToDefaultDomainsPolicy: pathnames " + string);
    }

    public Domain getDefaultDomain() {
        Debug.assert(1, this._default_domains != null, "default domains are invalid (== null)");
        return this._default_domains[0];
    }

    public void setDefaultDomain(Domain domain) {
        this._default_domains = new Domain[1];
        this._default_domains[0] = domain;
    }

    public Domain[] OnReferenceCreation(Object object, Domain domain) {
        if (this._default_domains == null) {
            this._default_domains = this.resolveAllDomains(this._default_pathnames, domain);
            if (this._default_domains.length == 0) {
                Debug.output(32770, "MapToDefaultDomainsPolicy: no default domains provided, using supplied root domain");
                Domain[] domainArray = new Domain[]{domain};
                return domainArray;
            }
        }
        return this._default_domains;
    }

    private String[] createStringArrayFromString(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private Domain[] resolveAllDomains(String[] stringArray, Domain domain) {
        int n = 0;
        Domain[] domainArray = new Domain[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                Debug.output(32770, "MapToDefaultDomainsPolicy.resolveAllDomains, trying to resolve " + stringArray[n2] + " at domain " + domain.name());
                domainArray[n2] = domain.resolveDomainPathName(stringArray[n2]);
            }
            catch (InvalidName invalidName) {
                ++n;
                Debug.output(32770, "MapToDefaultDomainsPolicy.resolveAllDomains, resolving " + stringArray[n2] + " at domain " + domain.name() + " failed!");
            }
            ++n2;
        }
        if (n == 0) {
            return domainArray;
        }
        Domain[] domainArray2 = new Domain[stringArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (domainArray[n4] != null) {
                domainArray2[n3] = domainArray[n4];
                ++n3;
            }
            ++n4;
        }
        return domainArray2;
    }

    public String short_description() {
        return "";
    }

    public void short_description(String string) {
    }

    public String long_description() {
        return "";
    }

    public void long_description(String string) {
    }

    public short strategy() {
        return 1;
    }

    public int policy_type() {
        return 115;
    }

    public Policy copy() {
        return new MapToDefaultDomainsPolicy(this._pathnames);
    }

    public void destroy() {
        this._default_domains = null;
        this._default_pathnames = null;
        this._pathnames = null;
    }
}

