/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.LocalityConstrainedObject;
import org.jacorb.orb.ORB;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.IIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class SSLComponentInterceptor
extends LocalityConstrainedObject
implements IORInterceptor {
    private ORB orb = null;

    public SSLComponentInterceptor(ORB oRB) {
        this.orb = oRB;
    }

    public String name() {
        return "SSLComponentCreator";
    }

    public void establish_components(IORInfo iORInfo) {
        try {
            Version version = new Version(1, 1);
            SSL sSL = new SSL(Environment.supportedBySSL(), Environment.requiredBySSL(), (short)this.orb.getBasicAdapter().getSSLPort());
            if (!Environment.enforceSSL()) {
                sSL.target_supports = (short)(sSL.target_supports | 1);
            }
            CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
            cDROutputStream.beginEncapsulatedArray();
            SSLHelper.write(cDROutputStream, sSL);
            TaggedComponent taggedComponent = new TaggedComponent(20, cDROutputStream.getBufferCopy());
            cDROutputStream.close();
            iORInfo.add_ior_component_to_profile(taggedComponent, 0);
        }
        catch (Exception exception) {
            Debug.output(0x10000001, exception);
        }
    }
}

