/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.util.Debug;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private Interceptor[] client_req_interceptors = null;
    private Interceptor[] server_req_interceptors = null;
    private Interceptor[] ior_interceptors = null;
    private Hashtable currents = null;
    private ORB orb = null;
    private int current_slots = 0;
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(Vector vector, Vector vector2, Vector vector3, int n, ORB oRB) {
        int n2;
        int n3;
        Debug.output(16386, "InterceptorManager started with " + vector2.size() + " SIs, " + vector.size() + " CIs and " + vector3.size() + " IORIs");
        this.client_req_interceptors = new ClientRequestInterceptor[vector.size()];
        int n4 = 0;
        while (n4 < this.client_req_interceptors.length) {
            String string = ((ClientRequestInterceptor)vector.elementAt(0)).name();
            int n5 = 0;
            n3 = 1;
            while (n3 < vector.size()) {
                if (string.compareTo(((ClientRequestInterceptor)vector.elementAt(n3)).name()) > 0) {
                    string = ((ClientRequestInterceptor)vector.elementAt(n3)).name();
                    n5 = n3;
                }
                ++n3;
            }
            this.client_req_interceptors[n4] = (ClientRequestInterceptor)vector.elementAt(n5);
            vector.removeElementAt(n5);
            ++n4;
        }
        this.server_req_interceptors = new ServerRequestInterceptor[vector2.size()];
        int n6 = 0;
        while (n6 < this.server_req_interceptors.length) {
            String string = ((ServerRequestInterceptor)vector2.elementAt(0)).name();
            n3 = 0;
            n2 = 1;
            while (n2 < vector2.size()) {
                if (string.compareTo(((ServerRequestInterceptor)vector2.elementAt(n2)).name()) > 0) {
                    string = ((ServerRequestInterceptor)vector2.elementAt(n2)).name();
                    n3 = n2;
                }
                ++n2;
            }
            this.server_req_interceptors[n6] = (ServerRequestInterceptor)vector2.elementAt(n3);
            vector2.removeElementAt(n3);
            ++n6;
        }
        this.ior_interceptors = new IORInterceptor[vector3.size()];
        int n7 = 0;
        while (n7 < this.ior_interceptors.length) {
            String string = ((IORInterceptor)vector3.elementAt(0)).name();
            n2 = 0;
            int n8 = 1;
            while (n8 < vector3.size()) {
                if (string.compareTo(((IORInterceptor)vector3.elementAt(n8)).name()) > 0) {
                    string = ((IORInterceptor)vector3.elementAt(n8)).name();
                    n2 = n8;
                }
                ++n8;
            }
            this.ior_interceptors[n7] = (IORInterceptor)vector3.elementAt(n2);
            vector3.removeElementAt(n2);
            ++n7;
        }
        this.orb = oRB;
        this.current_slots = n;
        this.currents = new Hashtable();
    }

    public Current getCurrent() {
        Current current = (Current)this.currents.get(Thread.currentThread());
        if (current == null) {
            Debug.output(16386, "InterceptorManager.getCurrent() creates new empty PI current");
            current = this.getEmptyCurrent();
            this.currents.put(Thread.currentThread(), current);
        }
        return current;
    }

    public void setTSCurrent(Current current) {
        this.currents.put(Thread.currentThread(), new PICurrentImpl((PICurrentImpl)current));
    }

    public void removeTSCurrent() {
        this.currents.remove(Thread.currentThread());
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.ior_interceptors);
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }
}

