/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jacorb.orb.ParsedIOR;
import org.omg.CORBA.Object;
import org.omg.IOP.IOR;

public class PropertyDialog
extends JDialog {
    Object _object;
    JTabbedPane TabbedPane = new JTabbedPane();
    JLabel TypeIdLabel = new JLabel();
    JLabel HostLabel = new JLabel();
    JLabel ObjectKeyLabel = new JLabel();

    public PropertyDialog(Object object, Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this._object = object;
            this.initIORPane(this._object);
            this.setLocationRelativeTo(frame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }

    public PropertyDialog(Object object, Frame frame, String string) {
        this(object, frame, string, false);
    }

    public PropertyDialog(Object object, Frame frame) {
        this(object, frame, "", false);
    }

    private void jbInit() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        gridBagLayout.setConstraints(this.TabbedPane, gridBagConstraints);
        this.getContentPane().add(this.TabbedPane);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.dispose();
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.getContentPane().add(jButton);
        this.add("IOR", this.createIORPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertyDialog.this.dispose();
            }
        });
    }

    private JPanel createIORPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("IOR Components"));
        jPanel2.add("North", this.TypeIdLabel);
        jPanel2.add("Center", this.HostLabel);
        jPanel2.add("South", this.ObjectKeyLabel);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void initIORPane(Object object) {
        ParsedIOR parsedIOR = new ParsedIOR(object.toString());
        IOR iOR = parsedIOR.getIOR();
        this.TypeIdLabel.setText("Type ID: " + iOR.type_id);
        this.HostLabel.setText("Host: " + parsedIOR.getAddress());
        this.ObjectKeyLabel.setText("Object Key: " + PropertyDialog.dumpHex(parsedIOR.get_object_key()));
    }

    public static String dumpHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] & 0xFF) / 16;
            int n3 = (byArray[n] & 0xFF) % 16;
            char c = n2 > 9 ? (char)(65 + (n2 - 10)) : (char)(48 + n2);
            char c2 = n3 > 9 ? (char)(65 + (n3 - 10)) : (char)(48 + n3);
            stringBuffer.append(c);
            stringBuffer.append(c2);
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public Component add(String string, Component component) {
        this.TabbedPane.addTab(string, component);
        return component;
    }

    public Component add(String string, Component component, int n) {
        this.TabbedPane.insertTab(string, null, component, string, n);
        return component;
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
    }
}

