/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.UIManager;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.gui.BrowserFrame;
import org.jacorb.orb.domain.gui.SharedData;
import org.jacorb.orb.domain.gui.SharedDataImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.ORB;

public class Browser {
    boolean packFrame = false;

    public Browser(SharedData sharedData, Domain domain) {
        BrowserFrame browserFrame = domain == null ? new BrowserFrame(sharedData) : new BrowserFrame(sharedData, domain);
        if (this.packFrame) {
            browserFrame.pack();
        } else {
            browserFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = browserFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        int n = dimension2.width / 5;
        int n2 = dimension2.height / 5;
        ((Component)browserFrame).setLocation((dimension.width - dimension2.width) / 2 + (sharedData.getFrameCount() - 1) * n, (dimension.height - dimension2.height) / 2 + (sharedData.getFrameCount() - 1) * n2);
        ((Component)browserFrame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SharedDataImpl sharedDataImpl = new SharedDataImpl();
            if (stringArray.length == 0) {
                new Browser(sharedDataImpl, null);
            } else {
                Domain domain = null;
                ORB oRB = sharedDataImpl.getORB();
                String string = Browser.readIORStringFromArguments(stringArray);
                try {
                    domain = DomainHelper.narrow(oRB.string_to_object(string));
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                    domain = null;
                }
                new Browser(sharedDataImpl, domain);
            }
            Debug.output(32770, "Domain Browser up.");
        }
        catch (Exception exception) {
            Debug.output(32769, exception);
        }
    }

    private static String readIORStringFromArguments(String[] stringArray) {
        Debug.assert(1, stringArray.length > 0, "Browser.readIORStringFromArguments: no arguments.");
        String string = null;
        if (stringArray[0].equals("-f")) {
            String string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[1]), 2048);
                string2 = bufferedReader.readLine();
                if (string2 != null) {
                    string = string2;
                    while (string2 != null) {
                        string2 = bufferedReader.readLine();
                        if (string2 == null) continue;
                        string = string + string2;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            string = stringArray[0];
        }
        return string;
    }

    private static void usage() {
        System.err.println("Usage: jaco org.jacorb.orb.domain.gui.Browser [<IOR> | -f <filename>]");
        System.exit(-1);
    }
}

