/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jacorb.orb.domain.ManagementPolicyImpl;
import org.jacorb.orb.domain.PolicyFactory;
import org.jacorb.orb.domain.PropertyAlreadyDefined;
import org.jacorb.orb.domain.PropertyPolicy;
import org.jacorb.orb.domain.PropertyPolicyHelper;
import org.jacorb.orb.domain.PropertyPolicyOperations;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;

public class PropertyPolicyImpl
extends ManagementPolicyImpl
implements PropertyPolicyOperations {
    private Properties theProperties = new Properties();
    private int theType = 112;

    public PropertyPolicyImpl() {
        this("property policy");
    }

    public PropertyPolicyImpl(String string) {
        super(string);
    }

    public String name() {
        return this.short_description();
    }

    public void name(String string) {
        this.short_description(string);
    }

    public void setPolicyType(int n) {
        this.theType = n;
    }

    public int policy_type() {
        return this.theType;
    }

    public Policy copy() {
        return new PropertyPolicyImpl()._this();
    }

    public void put(String string, String string2) throws PropertyAlreadyDefined {
        if (((Hashtable)this.theProperties).containsKey(string)) {
            throw new PropertyAlreadyDefined();
        }
        ((Hashtable)this.theProperties).put(string, string2);
    }

    public String[] getPropertyNames() {
        Enumeration enumeration = ((Hashtable)this.theProperties).keys();
        String[] stringArray = new String[((Hashtable)this.theProperties).size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getValueOfProperty(String string) {
        java.lang.Object v = ((Hashtable)this.theProperties).get(string);
        if (v != null) {
            return (String)v;
        }
        return "";
    }

    public void changeValueOfProperty(String string, String string2) {
        ((Hashtable)this.theProperties).put(string, string2);
    }

    public boolean containsProperty(String string) {
        return ((Hashtable)this.theProperties).containsKey(string);
    }

    public void removeProperty(String string) {
        ((Hashtable)this.theProperties).remove(string);
    }

    public int getPropertyCount() {
        return ((Hashtable)this.theProperties).size();
    }

    public static void loadFromFile(PropertyPolicy propertyPolicy, File file, String string) throws IOException {
        if (string == null) {
            string = "org.jacorb.policy.";
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        Hashtable<String, PropertyPolicy> hashtable = new Hashtable<String, PropertyPolicy>(1);
        hashtable.put(propertyPolicy.short_description(), propertyPolicy);
        try {
            PropertyPolicyImpl.updatePropertyPolicies(properties, string, hashtable, null);
        }
        catch (NullPointerException nullPointerException) {
            Debug.output(32772, "PropertyPolicyImpl.loadFromFile: harmless exception");
        }
    }

    public static void storeToFile(PropertyPolicy propertyPolicy, File file, String string) throws IOException {
        if (string == null) {
            string = "org.jacorb.policy.";
        }
        String string2 = ".";
        Properties properties = new Properties();
        String[] stringArray = propertyPolicy.getPropertyNames();
        ((Hashtable)properties).put(string + propertyPolicy.short_description() + string2 + "type", new Integer(propertyPolicy.policy_type()).toString());
        ((Hashtable)properties).put(string + propertyPolicy.short_description() + string2 + "description", propertyPolicy.long_description());
        int n = 0;
        while (n < stringArray.length) {
            ((Hashtable)properties).put(string + propertyPolicy.short_description() + string2 + stringArray[n], propertyPolicy.getValueOfProperty(stringArray[n]));
            ++n;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        properties.save(bufferedOutputStream, "properties of policy " + propertyPolicy.short_description());
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void updatePropertyPolicies(Properties properties, String string, Hashtable hashtable, PolicyFactory policyFactory) {
        Enumeration<?> enumeration = properties.propertyNames();
        if (string == null) {
            string = "org.jacorb.policy.";
        }
        String string2 = ".";
        PropertyPolicy propertyPolicy = null;
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string)) continue;
            int n = string.length();
            int n2 = string3.indexOf(string2, n);
            if (n2 < 0) {
                Debug.output(32771, "Environment.updatePropertyPolicies: policy  name not found ");
                continue;
            }
            String string4 = string3.substring(n, n2);
            Debug.output(32771, "found policy name:" + string4);
            java.lang.Object v = hashtable.get(string4);
            if (v != null) {
                try {
                    propertyPolicy = PropertyPolicyHelper.narrow((Object)v);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    bAD_PARAM.printStackTrace();
                }
            } else {
                propertyPolicy = policyFactory.createPropertyPolicy();
                propertyPolicy.name(string4);
                hashtable.put(string4, propertyPolicy);
                Debug.output(32772, "created policy " + string4);
            }
            String string5 = string3.substring(n2 + 1, string3.length());
            String string6 = (String)((Hashtable)properties).get(string3);
            if (string5.equalsIgnoreCase("Name")) {
                propertyPolicy.name(string6);
                continue;
            }
            Debug.output(32771, "property name: " + string5 + " property valuee: " + string6 + " property policy object : " + propertyPolicy);
            if (string5.equalsIgnoreCase("Type")) {
                try {
                    propertyPolicy.setPolicyType(Integer.parseInt(string6));
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(32769, "Environment.updatePropertyPolicies: couldn't parse value to integer, skipping.");
                }
                continue;
            }
            if (string5.equalsIgnoreCase("description")) {
                propertyPolicy.long_description(string6);
                continue;
            }
            try {
                propertyPolicy.put(string5, string6);
            }
            catch (PropertyAlreadyDefined propertyAlreadyDefined) {
                propertyPolicy.removeProperty(string5);
                try {
                    propertyPolicy.put(string5, string6);
                }
                catch (PropertyAlreadyDefined propertyAlreadyDefined2) {
                    Debug.output(32769, "Environment.updatePropertyPolicies: impossible ERROR occured !!!");
                }
            }
            Debug.output(32772, "added ( " + string5 + ", " + string6 + ")");
        }
    }
}

