/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.util.Hashtable;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.DomainListHelper;
import org.jacorb.orb.domain.GraphNode;
import org.jacorb.orb.domain.GraphNodeHelper;
import org.jacorb.orb.domain.GraphNodeOperations;
import org.jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import org.jacorb.orb.domain.GraphNodePackage.ClosesCycleHelper;
import org.jacorb.orb.domain.NameAlreadyDefined;
import org.jacorb.orb.domain.NameAlreadyDefinedHelper;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class GraphNodePOA
extends Servant
implements InvokeHandler,
GraphNodeOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:org/jacorb/orb/domain/GraphNode:1.0", "IDL:omg.org/CORBA/Object:1.0"};

    public GraphNode _this() {
        return GraphNodeHelper.narrow(this._this_object());
    }

    public GraphNode _this(ORB oRB) {
        return GraphNodeHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                int n2 = inputStream.read_long();
                outputStream = responseHandler.createReply();
                PolicyHelper.write(outputStream, this.getEffectiveDomainPolicy(n2));
                break;
            }
            case 1: {
                outputStream = responseHandler.createReply();
                DomainListHelper.write(outputStream, this.getChilds());
                break;
            }
            case 2: {
                outputStream = responseHandler.createReply();
                DomainHelper.write(outputStream, this.getRootDomain());
                break;
            }
            case 3: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.hasParent(domain));
                break;
            }
            case 4: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                this.deleteParent(domain);
                break;
            }
            case 5: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                this.deleteChild(domain);
                break;
            }
            case 6: {
                try {
                    Domain domain = DomainHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.insertParent(domain);
                }
                catch (ClosesCycle closesCycle) {
                    outputStream = responseHandler.createExceptionReply();
                    ClosesCycleHelper.write(outputStream, closesCycle);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    outputStream = responseHandler.createExceptionReply();
                    NameAlreadyDefinedHelper.write(outputStream, nameAlreadyDefined);
                }
                break;
            }
            case 7: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.hasChild(domain));
                break;
            }
            case 8: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.isRoot());
                break;
            }
            case 9: {
                outputStream = responseHandler.createReply();
                outputStream.write_long(this.getParentCount());
                break;
            }
            case 10: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.isReachable(domain));
                break;
            }
            case 11: {
                outputStream = responseHandler.createReply();
                DomainListHelper.write(outputStream, this.getParents());
                break;
            }
            case 12: {
                outputStream = responseHandler.createReply();
                outputStream.write_long(this.getChildCount());
                break;
            }
            case 13: {
                try {
                    Domain domain = DomainHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.insertChild(domain);
                    break;
                }
                catch (ClosesCycle closesCycle) {
                    outputStream = responseHandler.createExceptionReply();
                    ClosesCycleHelper.write(outputStream, closesCycle);
                    break;
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    outputStream = responseHandler.createExceptionReply();
                    NameAlreadyDefinedHelper.write(outputStream, nameAlreadyDefined);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    public abstract int getParentCount();

    public abstract Domain[] getParents();

    public abstract boolean hasParent(Domain var1);

    public abstract void deleteParent(Domain var1);

    public abstract void insertParent(Domain var1) throws ClosesCycle, NameAlreadyDefined;

    public abstract void deleteChild(Domain var1);

    public abstract int getChildCount();

    public abstract Domain[] getChilds();

    public abstract boolean isReachable(Domain var1);

    public abstract boolean hasChild(Domain var1);

    public abstract void insertChild(Domain var1) throws ClosesCycle, NameAlreadyDefined;

    public abstract Policy getEffectiveDomainPolicy(int var1);

    public abstract Domain getRootDomain();

    public abstract boolean isRoot();

    static {
        m_opsHash.put("getEffectiveDomainPolicy", new Integer(0));
        m_opsHash.put("getChilds", new Integer(1));
        m_opsHash.put("getRootDomain", new Integer(2));
        m_opsHash.put("hasParent", new Integer(3));
        m_opsHash.put("deleteParent", new Integer(4));
        m_opsHash.put("deleteChild", new Integer(5));
        m_opsHash.put("insertParent", new Integer(6));
        m_opsHash.put("hasChild", new Integer(7));
        m_opsHash.put("isRoot", new Integer(8));
        m_opsHash.put("getParentCount", new Integer(9));
        m_opsHash.put("isReachable", new Integer(10));
        m_opsHash.put("getParents", new Integer(11));
        m_opsHash.put("getChildCount", new Integer(12));
        m_opsHash.put("insertChild", new Integer(13));
    }
}

