/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection.http;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.http.httpserver.ServeConnection;
import org.jacorb.util.Debug;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public final class ServerConnection
extends org.jacorb.orb.connection.ServerConnection {
    private boolean connected = true;
    private int readcount = 0;
    private boolean readyParsed = false;
    java.lang.Object oldrequest;
    java.lang.Object requestwait = new java.lang.Object();
    ServeConnection realCon;
    Socket mysock;

    public ServerConnection(ORB oRB, boolean bl, Socket socket, InputStream inputStream) throws IOException {
        this.orb = oRB;
        this.mysock = socket;
        this.isSSL = bl;
        this.in_stream = new BufferedInputStream(inputStream);
        this.realCon = new ServeConnection(socket, inputStream);
        String string = this.mysock.getInetAddress().getHostAddress();
        if (string.indexOf(47) > 0) {
            string = string.substring(string.indexOf(47) + 1);
        }
        String string2 = string + ":" + this.mysock.getPort();
        String string3 = this.isSSL() ? "SSL " : "";
        this.connection_info = string2;
        this.client_count = 1;
        Debug.output(1, "Accepted HTTP connection from " + string2);
    }

    protected void abort() throws EOFException {
        Debug.output(3, "HTTPServerConnection to " + this.connection_info + " aborting...");
        throw new EOFException();
    }

    public synchronized void closeConnection() {
        this.connected = false;
        this.realCon.close();
    }

    public boolean connected() {
        return this.connected;
    }

    public byte[] readBuffer() throws IOException {
        ++this.readcount;
        this.in_stream = this.realCon.getInputStream();
        return super.readBuffer();
    }

    public synchronized void reconnect() throws COMM_FAILURE {
        this.connected = true;
    }

    public synchronized void sendCloseConnection() throws COMM_FAILURE {
        String string = this.mysock.getInetAddress().toString() + this.mysock.getPort();
        try {
            this.realCon.answerRequest(Messages.closeConnectionMessage());
            this.realCon.close();
        }
        catch (Exception exception) {
            throw new COMM_FAILURE();
        }
    }

    public void sendLocateReply(int n, int n2, Object object) throws COMM_FAILURE {
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            String string = this.mysock.getInetAddress().toString() + this.mysock.getPort();
            try {
                this.realCon.answerRequest(Messages.locateReplyMessage(n, n2, object));
                this.realCon.close();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public void sendReply(ReplyOutputStream replyOutputStream) throws IOException {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            String string = this.mysock.getInetAddress().toString() + this.mysock.getPort();
            try {
                if (replyOutputStream != null) {
                    this.realCon.answerRequest(replyOutputStream.getBufferCopy());
                    replyOutputStream.release();
                } else {
                    byte[] byArray = new byte[]{0};
                    this.realCon.answerRequest(byArray);
                }
                this.realCon.close();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public void setTimeOut(int n) throws SocketException {
    }
}

