/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.AbstractConnection;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class ServerConnection
extends AbstractConnection {
    protected String connection_info = null;
    protected InputStream in_stream;
    BufferedOutputStream out_stream;
    public java.lang.Object writeLock = new java.lang.Object();
    protected boolean littleEndian;
    protected boolean isSSL;
    protected Socket mysock = null;
    private byte[] header = new byte[Messages.MSG_HEADER_SIZE];

    public ServerConnection() {
    }

    public ServerConnection(ORB oRB, boolean bl, Socket socket) throws IOException {
        this(oRB, bl, socket, new BufferedInputStream(socket.getInputStream()));
    }

    public ServerConnection(ORB oRB, boolean bl, Socket socket, InputStream inputStream) throws IOException {
        this.orb = oRB;
        this.isSSL = bl;
        this.mysock = socket;
        this.in_stream = inputStream;
        this.out_stream = new BufferedOutputStream(this.mysock.getOutputStream(), Environment.outBufSize());
        String string = this.mysock.getInetAddress().getHostAddress();
        if (string.indexOf(47) > 0) {
            string = string.substring(string.indexOf(47) + 1);
        }
        String string2 = string + ":" + this.mysock.getPort();
        String string3 = this.isSSL() ? "SSL " : "";
        this.connection_info = string2;
        Debug.output(1, "Accepted " + string3 + "connection from " + string2);
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public Socket getSocket() {
        return this.mysock;
    }

    public boolean connected() {
        return this.mysock != null;
    }

    public synchronized void closeConnection() {
        Debug.output(1, "Closing connection to " + this.connection_info);
        try {
            try {
                if (this.mysock != null) {
                    this.mysock.close();
                }
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
            }
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            Debug.output(4, "Closing connection to " + this.connection_info + " (in streams closed)");
            if (this.out_stream != null) {
                this.out_stream.close();
            }
            Debug.output(4, "Closing connection to " + this.connection_info + " (out streams closed)");
        }
        catch (IOException iOException) {
            Debug.output(4, iOException);
        }
        this.in_stream = null;
        this.out_stream = null;
        this.mysock = null;
        Debug.output(3, "Closing connection to " + this.connection_info + " (sockets closed)");
    }

    private void abort() throws EOFException {
        Debug.output(3, "Connection to " + this.connection_info + " aborting...");
        throw new EOFException();
    }

    public byte[] readBuffer() throws IOException {
        int n;
        int n2 = 0;
        while (n2 < Messages.MSG_HEADER_SIZE) {
            n = -1;
            try {
                n = this.in_stream.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.output(3, "Connection timed out");
            }
            catch (Exception exception) {
                Debug.output(3, exception);
            }
            if (n < 0) {
                this.abort();
            }
            this.header[n2] = (byte)n;
            ++n2;
        }
        if ((char)this.header[0] == 'S' && (char)this.header[1] == 'E' && (char)this.header[2] == 'C' && (char)this.header[3] == 'P') {
            throw new IOException("Cannot handle SECIOP messages yet...");
        }
        if ((char)this.header[0] == 'G' && (char)this.header[1] == 'I' && (char)this.header[2] == 'O' && (char)this.header[3] == 'P') {
            n = 0;
            n = this.header[6] == 0 ? ((0xFF & this.header[8]) << 24) + ((0xFF & this.header[9]) << 16) + ((0xFF & this.header[10]) << 8) + (0xFF & this.header[11]) : ((0xFF & this.header[11]) << 24) + ((0xFF & this.header[10]) << 16) + ((0xFF & this.header[9]) << 8) + (0xFF & this.header[8]);
            if (n < 0) {
                this.abort();
            }
            int n3 = n + Messages.MSG_HEADER_SIZE;
            byte[] byArray = BufferManager.getInstance().getBuffer(n3);
            int n4 = 0;
            while (n4 < Messages.MSG_HEADER_SIZE) {
                byArray[n4] = this.header[n4];
                ++n4;
            }
            int n5 = Messages.MSG_HEADER_SIZE;
            while (n5 < n3) {
                int n6 = -1;
                try {
                    n6 = this.in_stream.read(byArray, n5, n3 - n5);
                }
                catch (IOException iOException) {
                    Debug.output(4, iOException);
                }
                if (n6 < 0) {
                    this.abort();
                }
                n5 += n6;
            }
            return byArray;
        }
        Debug.output(0, "Unknown message header type detected by " + Thread.currentThread().getName() + ", discarding ", this.header);
        return this.readBuffer();
    }

    public String getInfo() {
        return this.connection_info;
    }

    public synchronized void sendCloseConnection() throws COMM_FAILURE {
        try {
            this.out_stream.write(Messages.closeConnectionMessage());
            this.out_stream.flush();
            this.closeConnection();
        }
        catch (Exception exception) {
            throw new COMM_FAILURE();
        }
    }

    public void sendLocateReply(int n, int n2, Object object) throws COMM_FAILURE {
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            try {
                this.out_stream.write(Messages.locateReplyMessage(n, n2, object));
                this.out_stream.flush();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public void sendReply(ReplyOutputStream replyOutputStream) throws IOException {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            try {
                if (Environment.verbosityLevel() > 4) {
                    Debug.output(5, "send reply", replyOutputStream.getBufferCopy());
                }
                replyOutputStream.write_to(this.out_stream);
                replyOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public void setTimeOut(int n) throws SocketException {
        this.mysock.setSoTimeout(n);
    }

    public BufferedOutputStream get_out_stream() {
        return this.out_stream;
    }

    public void writeDirectly(byte[] byArray, int n) throws IOException {
        this.get_out_stream().write(byArray, 0, n);
        this.get_out_stream().flush();
    }
}

