/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Principal;
import org.jacorb.orb.dii.Request;
import org.omg.CORBA.ORB;
import org.omg.GIOP.RequestHeader_1_0;
import org.omg.GIOP.RequestHeader_1_0Helper;
import org.omg.IOP.ServiceContext;

public class RequestOutputStream
extends CDROutputStream {
    private RequestHeader_1_0 req_hdr;
    private boolean exact_size = false;
    private Request request = null;

    public RequestOutputStream(ORB oRB, int n, String string, boolean bl, byte[] byArray, ServiceContext[] serviceContextArray) {
        this(oRB, n, string, bl, byArray, serviceContextArray, false);
    }

    public RequestOutputStream(ORB oRB, int n, String string, boolean bl, byte[] byArray, ServiceContext[] serviceContextArray, boolean bl2) {
        super(oRB);
        Principal principal = new Principal(new byte[0]);
        this.req_hdr = new RequestHeader_1_0(serviceContextArray, n, bl, byArray, string, new byte[0]);
        if (bl2) {
            this.header_stream = new CDROutputStream();
        } else {
            this.writeHeader(this);
        }
    }

    private void writeHeader(CDROutputStream cDROutputStream) {
        cDROutputStream.writeGIOPMsgHeader((byte)0);
        RequestHeader_1_0Helper.write(cDROutputStream, this.req_hdr);
    }

    public int requestId() {
        return this.req_hdr.request_id;
    }

    public boolean response_expected() {
        return this.req_hdr.response_expected;
    }

    public String operation() {
        return this.req_hdr.operation;
    }

    public ServiceContext[] getServiceContexts() {
        return this.req_hdr.service_context;
    }

    public void setServiceContexts(ServiceContext[] serviceContextArray) {
        if (serviceContextArray[serviceContextArray.length - 1].context_id != Integer.MAX_VALUE) {
            throw new Error("Last ServiceContext in array must be of type Integer.MAX_VALUE!");
        }
        this.req_hdr.service_context = serviceContextArray;
        this.writeHeader(this.header_stream);
        int n = 8 - this.header_stream.size() % 8;
        int n2 = n = n == 8 ? 0 : n;
        if (n > 0) {
            this.req_hdr.service_context[serviceContextArray.length - 1].context_data = new byte[n];
            this.header_stream.reset();
            this.writeHeader(this.header_stream);
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }
}

