/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.GIOP.MessageHeader_1_0;
import org.omg.GIOP.MessageHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.PortableServer.ForwardRequest;

public class ReplyInputStream
extends CDRInputStream {
    private ReplyHeader_1_0 rep_hdr;
    private int _request_id;
    private boolean _response_expected;
    private String _operation;
    private boolean ready = false;
    private boolean communicationException = false;
    private boolean remarshalException = false;
    private Object target;
    public MessageHeader_1_0 msg_hdr = null;

    public ReplyInputStream(ORB oRB, int n) {
        super(oRB, new byte[0]);
        this._request_id = n;
    }

    public synchronized void init(byte[] byArray, Object object) {
        this.buffer = byArray;
        this.target = object;
        this.ready = true;
        this.notify();
    }

    private void wakeup() {
        if (this.buffer[6] != 0) {
            this.littleEndian = true;
            this.setLittleEndian(true);
        }
        if (this.buffer[7] != 1) {
            throw new RuntimeException("Trying to initialize ReplyInputStream from non-reply msg.!");
        }
        if (this.buffer[5] == 1) {
            this.skip(12);
        } else {
            this.msg_hdr = MessageHeader_1_0Helper.read(this);
        }
        this.rep_hdr = ReplyHeader_1_0Helper.read(this);
        if (this._request_id != this.rep_hdr.request_id) {
            throw new RuntimeException("Fatal, request ids don't match");
        }
    }

    public synchronized void cancel() {
        this.communicationException = true;
        this.ready = true;
        this.notify();
    }

    public synchronized void retry() {
        this.remarshalException = true;
        this.ready = true;
        this.notify();
    }

    public int requestId() {
        return this._request_id;
    }

    public ReplyHeader_1_0 getHeader() {
        return this.rep_hdr;
    }

    public synchronized InputStream result() throws ApplicationException, RemarshalException, ForwardRequest {
        try {
            while (!this.ready) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.communicationException) {
            throw new COMM_FAILURE();
        }
        if (this.remarshalException) {
            throw new RemarshalException();
        }
        this.wakeup();
        boolean bl = false;
        switch (this.rep_hdr.reply_status.value()) {
            case 0: {
                return this;
            }
            case 1: {
                String string = this.read_string();
                this.unread_string(string);
                throw new ApplicationException(string, this);
            }
            case 2: {
                throw SystemExceptionHelper.read(this);
            }
            case 3: {
                throw new ForwardRequest(this.read_Object());
            }
        }
        return this;
    }

    public synchronized InputStream rawResult() {
        try {
            while (!this.ready) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.communicationException) {
            throw new COMM_FAILURE();
        }
        this.wakeup();
        return this;
    }
}

