/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.util.Vector;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ParsedIOR {
    private int effectiveProfileBody = 0;
    protected ProfileBody_1_1[] profileBodies = null;
    public TaggedComponent[] taggedComponents = new TaggedComponent[0];
    public TaggedProfile[] effectiveProfile;
    protected boolean endianness = false;
    protected String ior_str = null;
    protected IOR ior = null;
    private ORB orb;

    public static IOR createIOR(String string, ProfileBody_1_0 profileBody_1_0) {
        IOR iOR = new IOR();
        iOR.type_id = string;
        iOR.profiles = new TaggedProfile[1];
        iOR.profiles[0] = new TaggedProfile();
        iOR.profiles[0].tag = 0;
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.write_boolean(false);
        ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
        iOR.profiles[0].profile_data = cDROutputStream.getBufferCopy();
        return iOR;
    }

    public static ProfileBody_1_1 getProfileBody(byte[] byArray, int n) {
        ProfileBody_1_1 profileBody_1_1 = null;
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        try {
            cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
            cDRInputStream.mark(0);
            byte by = VersionHelper.read((InputStream)cDRInputStream).minor;
            if (by < n || by > 2) {
                return null;
            }
            cDRInputStream.reset();
            switch (by) {
                case 1: 
                case 2: {
                    profileBody_1_1 = ProfileBody_1_1Helper.read(cDRInputStream);
                    break;
                }
                case 0: {
                    ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(cDRInputStream);
                    profileBody_1_1 = new ProfileBody_1_1(profileBody_1_0.iiop_version, profileBody_1_0.host, profileBody_1_0.port, profileBody_1_0.object_key, new TaggedComponent[0]);
                    if (profileBody_1_1.port >= 0) break;
                    profileBody_1_1.port = (short)(profileBody_1_1.port + 65536);
                }
            }
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            throw new INV_OBJREF();
        }
        return profileBody_1_1;
    }

    public static SSL getSSLTaggedComponent(TaggedComponent[] taggedComponentArray) {
        boolean bl = false;
        int n = 0;
        while (n < taggedComponentArray.length) {
            if (taggedComponentArray[n].tag == 20) {
                bl = true;
                CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponentArray[n].component_data);
                try {
                    cDRInputStream.openEncapsulatedArray();
                    return SSLHelper.read(cDRInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public static SSL getSSLTaggedComponent(ProfileBody_1_1 profileBody_1_1) {
        if (profileBody_1_1 == null || (char)profileBody_1_1.iiop_version.minor == '\u0000' || profileBody_1_1.components == null) {
            return null;
        }
        boolean bl = false;
        int n = 0;
        while (n < profileBody_1_1.components.length) {
            if (profileBody_1_1.components[n].tag == 20) {
                bl = true;
                Debug.output(8, "Component data", profileBody_1_1.components[n].component_data);
                CDRInputStream cDRInputStream = new CDRInputStream(null, profileBody_1_1.components[n].component_data);
                try {
                    cDRInputStream.openEncapsulatedArray();
                    return SSLHelper.read(cDRInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        int n = 0;
        while (n < this.taggedComponents.length) {
            if (this.taggedComponents[n].tag == 1) {
                Debug.output(4, "TAG_CODE_SETS found");
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, this.taggedComponents[n].component_data);
                cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                return CodeSetComponentInfoHelper.read(cDRInputStream);
            }
            ++n;
        }
        return null;
    }

    public ParsedIOR(String string) {
        this.parse(string);
    }

    public ParsedIOR(String string, ORB oRB) {
        this.orb = oRB;
        this.parse(string);
    }

    public ParsedIOR(IOR iOR) {
        this.decode(iOR);
    }

    public void decode(IOR iOR) {
        boolean bl = false;
        Vector<ProfileBody_1_1> vector = new Vector<ProfileBody_1_1>();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < iOR.profiles.length) {
            Debug.output(4, "Parsing IOR, found profile id: " + iOR.profiles[n].tag);
            switch (iOR.profiles[n].tag) {
                case 1: {
                    Debug.output(4, "TAG_MULTIPLE_COMPONENTS found in IOR");
                    CDRInputStream cDRInputStream = new CDRInputStream(null, iOR.profiles[n].profile_data);
                    cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                    this.taggedComponents = MultipleComponentProfileHelper.read(cDRInputStream);
                    break;
                }
                case 0: {
                    Debug.output(4, "TAG_INTERNET_IOP found in IOR");
                    ProfileBody_1_1 profileBody_1_1 = ParsedIOR.getProfileBody(iOR.profiles[n].profile_data, 0);
                    if (profileBody_1_1 != null) {
                        vector.addElement(profileBody_1_1);
                        Debug.output(4, "IOP 1.1 decoded");
                    }
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl && iOR.profiles.length > 0) {
            throw new INV_OBJREF("no TAG_INTERNET_IOP found in object_reference");
        }
        this.profileBodies = new ProfileBody_1_1[vector.size()];
        vector.copyInto(this.profileBodies);
        this.effectiveProfileBody = 0;
        int n2 = 1;
        while (n2 < this.profileBodies.length) {
            if (this.profileBodies[n2].iiop_version.minor > this.profileBodies[this.effectiveProfileBody].iiop_version.minor) {
                this.effectiveProfileBody = n2;
            }
            ++n2;
        }
        this.ior = iOR;
        this.ior_str = this.getIORString();
    }

    public void decode(CorbaLoc corbaLoc) {
        IOR iOR = null;
        CorbaLoc.ObjectAddress objectAddress = corbaLoc.objectAddressList[0];
        if (objectAddress.protocol_identifier.equals("rir")) {
            try {
                Object object = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else if (objectAddress.protocol_identifier.equals("iiop")) {
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(objectAddress.getVersion(), objectAddress.host, (short)objectAddress.port, corbaLoc.getKey());
            iOR = ParsedIOR.createIOR("IDL:org.omg/CORBA/Object:1.0", profileBody_1_0);
        }
        this.decode(iOR);
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream();
                cDROutputStream.write_boolean(false);
                IORHelper.write(cDROutputStream, this.ior);
                byte[] byArray = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                int n = 0;
                while (n < byArray.length) {
                    int n2 = byArray[n];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    int n3 = (0xFF & n2) / 16;
                    int n4 = (0xFF & n2) % 16;
                    int n5 = n3 < 10 ? 48 + n3 : 97 + (n3 - 10);
                    int n6 = n4 < 10 ? 48 + n4 : 97 + (n4 - 10);
                    stringBuffer.append((char)n5);
                    stringBuffer.append((char)n6);
                    ++n;
                }
                this.ior_str = stringBuffer.toString();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public String getObjKey() {
        return new String(this.profileBodies[this.effectiveProfileBody].object_key);
    }

    public byte[] get_object_key() {
        return this.profileBodies[this.effectiveProfileBody].object_key;
    }

    public ProfileBody_1_1 getProfileBody() {
        return this.profileBodies[this.effectiveProfileBody];
    }

    public ProfileBody_1_1[] getProfileBodies() {
        return this.profileBodies;
    }

    public TaggedProfile getEffectiveProfile() {
        return this.ior.profiles[this.effectiveProfileBody];
    }

    public String getAddress() {
        int n = this.profileBodies[this.effectiveProfileBody].port;
        if (n < 0) {
            n += 65536;
        }
        return this.profileBodies[this.effectiveProfileBody].host + ":" + n;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public boolean isNull() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    protected void parse(String string) {
        if (string.startsWith("IOR:")) {
            this.ior_str = string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = (string.length() - 4) / 2;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c = string.charAt(n2 * 2 + 4);
                char c2 = string.charAt(n2 * 2 + 5);
                int n4 = c >= 'a' ? 10 + c - 97 : (n3 = c >= 'A' ? 10 + c - 65 : c - 48);
                int n5 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
                byteArrayOutputStream.write(n3 * 16 + n5);
                ++n2;
            }
            CDRInputStream cDRInputStream = new CDRInputStream(org.omg.CORBA.ORB.init(), byteArrayOutputStream.toByteArray());
            this.endianness = cDRInputStream.read_boolean();
            if (this.endianness) {
                cDRInputStream.setLittleEndian(true);
            }
            IOR iOR = IORHelper.read(cDRInputStream);
            this.decode(iOR);
        } else if (string.startsWith("corbaloc:")) {
            this.decode(new CorbaLoc(string));
        } else if (string.startsWith("http://") || string.startsWith("file:/")) {
            this.parse(ObjectUtil.readURL(string));
        } else if (string.startsWith("corbaname:")) {
            String string2;
            String string3 = "";
            if (string.indexOf(35) == -1) {
                string2 = "corbaloc:" + string.substring(string.indexOf(58) + 1);
            } else {
                string2 = "corbaloc:" + string.substring(string.indexOf(58) + 1, string.indexOf(35));
                string3 = string.substring(string.indexOf(35) + 1);
            }
            if (string2.indexOf(47) == -1) {
                string2 = string2 + "/NameService";
            }
            Debug.output(4, string2);
            try {
                NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.orb.string_to_object(string2));
                Object object = namingContextExt.resolve_str(string3);
                IOR iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
                this.decode(iOR);
            }
            catch (Exception exception) {
                Debug.output(4, exception);
                throw new RuntimeException("Invalid object reference: " + string);
            }
        } else {
            throw new RuntimeException("Invalid IOR format: " + string);
        }
    }
}

