/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Vector;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class BufferManager {
    private static BufferManager singleton = new BufferManager();
    private Vector[] bufferPool;
    private static int MAX;
    private static final int MIN_OFFSET = 5;
    private static final int THREASHOLD = 15;
    private int hits = 0;
    private int calls = 0;

    private BufferManager() {
        MAX = Environment.getMaxManagedBufSize();
        this.bufferPool = new Vector[MAX];
        int n = MAX;
        while (n > 0) {
            this.bufferPool[--n] = new Vector();
        }
    }

    public static BufferManager getInstance() {
        return singleton;
    }

    private static final int log2up(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2;
    }

    private static final int log2down(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    public synchronized byte[] getBuffer(int n) {
        ++this.calls;
        int n2 = BufferManager.log2up(n);
        if (n2 >= MAX + 5) {
            return new byte[n];
        }
        Vector vector = this.bufferPool[n2 > 5 ? n2 - 5 : 0];
        if (!vector.isEmpty()) {
            ++this.hits;
            Object e = vector.firstElement();
            vector.removeElementAt(0);
            return (byte[])e;
        }
        return new byte[n2 > 5 ? 1 << n2 : 32];
    }

    synchronized void returnBuffer(byte[] byArray) {
        int n = BufferManager.log2down(byArray.length);
        Debug.output(4, "return buffer: " + byArray.length + " bytes, log2: " + n);
        if (n >= 10) {
            if (n > MAX) {
                return;
            }
            Vector vector = this.bufferPool[n - 5];
            if (vector.size() < 15) {
                vector.addElement(byArray);
            }
        }
    }

    public void printStatistics() {
        System.out.println("BufferManager statistics:");
        System.out.println("\t get Buffer called: " + this.calls);
        System.out.println("\t buffers found in pool: " + this.hits);
        System.out.println("\t buffers size: ");
        int n = MAX;
        while (n > 0) {
            System.out.println("\t size 2**" + (5 + --n) + " # " + this.bufferPool[n].size());
        }
    }

    public void release() {
        int n = MAX;
        while (n > 0) {
            this.bufferPool[--n].removeAllElements();
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            System.out.println("log2up(" + n2 + "): " + BufferManager.log2up(n2));
            System.out.println("log2down(" + n2 + "): " + BufferManager.log2down(n2));
            ++n;
        }
    }
}

