/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ServerInfo;
import org.jacorb.util.Environment;

public class ImRTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean m_use_html_labels = false;

    public ImRTreeCellRenderer() {
        String string = Environment.getProperty("jacorb.imr.html_labels");
        try {
            this.m_use_html_labels = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 instanceof ImRInfo) {
            this.setText("Repository");
            this.setToolTipText("Port: " + ((ImRInfo)object2).port + ", Host: " + ((ImRInfo)object2).host);
        } else if (object2 instanceof POAInfo) {
            POAInfo pOAInfo = (POAInfo)object2;
            this.setToolTipText("POA is " + (pOAInfo.active ? "active" : "inactive"));
            if (this.m_use_html_labels) {
                String string = pOAInfo.active ? "green" : "red";
                this.setText("<html> <font color=" + string + ">" + pOAInfo.name + "</font></html>");
            } else {
                this.setText(pOAInfo.name);
            }
        } else if (object2 instanceof ServerInfo) {
            ServerInfo serverInfo = (ServerInfo)object2;
            this.setToolTipText("Server is " + (serverInfo.active ? "active" : "down") + (serverInfo.holding ? "and holding" : ""));
            if (this.m_use_html_labels) {
                String string = serverInfo.active ? "green" : "red";
                this.setText("<tml> <font color=" + string + ">" + (serverInfo.holding ? "<blink>" : "") + serverInfo.name + (serverInfo.holding ? "</blink>" : "") + "</font></html>");
            } else {
                this.setText(serverInfo.name);
            }
        }
        return this;
    }
}

