/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.ExtBufferedInputStream;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.LinkedList;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import HTTPClient.SocketTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private ExtBufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private LinkedList RespHandlerList;
    private int chunk_len;
    private int cur_timeout = 0;

    StreamDemultiplexor(int n, Socket socket, HTTPConnection hTTPConnection) throws IOException {
        this.Protocol = n;
        this.Connection = hTTPConnection;
        this.RespHandlerList = new LinkedList();
        this.init(socket);
    }

    private void init(Socket socket) throws IOException {
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: Initializing Stream Demultiplexor (" + this.hashCode() + ")");
        }
        this.Sock = socket;
        this.Stream = new ExtBufferedInputStream(socket.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1;
        this.Timer = TimerThread.setTimeout(this);
    }

    void register(Response response, Request request) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(response, request, this));
        }
    }

    RespInputStream getStream(Response response) {
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp == response) break;
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
        if (responseHandler != null) {
            return responseHandler.stream;
        }
        return null;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    int read(byte[] var1_1, int var2_2, int var3_3, ResponseHandler var4_4, int var5_5) throws IOException {
        if (var4_4.exception != null) {
            throw (IOException)var4_4.exception.fillInStackTrace();
        }
        if (!var4_4.eof) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                var6_6.stream.readAll(var5_5);
                continue;
            }
            catch (IOException var7_7) {
                if (var7_7 instanceof InterruptedIOException) {
                    throw var7_7;
                }
                throw (IOException)var4_4.exception.fillInStackTrace();
            }
lbl12:
            // 2 sources

            ** while ((var6_6 = (ResponseHandler)this.RespHandlerList.getFirst()) != null && var6_6 != var4_4)
        }
lbl13:
        // 1 sources

        var7_8 = this;
        synchronized (var7_8) {
            if (var4_4.exception != null) {
                throw (IOException)var4_4.exception.fillInStackTrace();
            }
            if (GlobalConstants.DebugDemux && var4_4.resp.cd_type != 1) {
                System.err.println("Demux: Reading for stream " + var4_4.stream.hashCode() + " (" + Thread.currentThread() + ")");
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                var8_9 = -1;
                if (var5_5 != this.cur_timeout) {
                    if (GlobalConstants.DebugDemux) {
                        System.err.println("Demux: Setting timeout to " + var5_5 + " ms");
                    }
                    try {
                        this.Sock.setSoTimeout(var5_5);
                    }
                    catch (Throwable var9_11) {
                        // empty catch block
                    }
                    this.cur_timeout = var5_5;
                }
                switch (var4_4.resp.cd_type) {
                    case 1: {
                        var8_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var8_9 != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        var8_9 = -1;
                        this.close(var4_4);
                        break;
                    }
                    case 3: {
                        var8_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var8_9 != -1) break;
                        this.close(var4_4);
                        break;
                    }
                    case 4: {
                        var9_12 = var4_4.resp.ContentLength;
                        if (var3_3 > var9_12 - var4_4.stream.count) {
                            var3_3 = var9_12 - var4_4.stream.count;
                        }
                        if ((var8_9 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (var4_4.stream.count + var8_9 != var9_12) break;
                        this.close(var4_4);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0) {
                            if (var3_3 > this.chunk_len) {
                                var3_3 = this.chunk_len;
                            }
                            if ((var8_9 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= var8_9;
                            if (this.chunk_len != 0) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1;
                            break;
                        }
                        var4_4.resp.readTrailers(this.Stream);
                        var8_9 = -1;
                        this.close(var4_4);
                        this.chunk_len = -1;
                        break;
                    }
                    case 6: {
                        var10_14 = var4_4.getEndBoundary(this.Stream);
                        var11_16 = var4_4.getEndCompiled(this.Stream);
                        var8_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var8_9 == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        var12_17 = this.Stream.pastEnd(var10_14, var11_16);
                        if (var12_17 == -1) break;
                        var8_9 -= var12_17;
                        this.Stream.reset();
                        this.close(var4_4);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + var4_4.resp.cd_type);
                    }
                }
                this.restartTimer();
                var13_18 = var8_9;
                return var13_18;
            }
            catch (InterruptedIOException var8_10) {
                this.restartTimer();
                throw var8_10;
            }
            catch (IOException var9_13) {
                if (GlobalConstants.DebugDemux) {
                    System.err.print("Demux: (" + Thread.currentThread() + ") ");
                    var9_13.printStackTrace();
                }
                this.close(var9_13, true);
                throw var4_4.exception;
            }
            catch (ParseException var10_15) {
                if (GlobalConstants.DebugDemux) {
                    System.err.print("Demux: (" + Thread.currentThread() + ") ");
                    var10_15.printStackTrace();
                }
                this.close(new IOException(var10_15.toString()), true);
                throw var4_4.exception;
            }
        }
    }

    synchronized long skip(long l, ResponseHandler responseHandler) throws IOException {
        if (responseHandler.exception != null) {
            throw (IOException)responseHandler.exception.fillInStackTrace();
        }
        if (responseHandler.eof) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l];
        int n = this.read(byArray, 0, (int)l, responseHandler, 0);
        if (n == -1) {
            return 0L;
        }
        return n;
    }

    synchronized int available(ResponseHandler responseHandler) throws IOException {
        int n = this.Stream.available();
        if (responseHandler == null) {
            return n;
        }
        if (responseHandler.exception != null) {
            throw (IOException)responseHandler.exception.fillInStackTrace();
        }
        if (responseHandler.eof) {
            return 0;
        }
        switch (responseHandler.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return n > 0 ? 1 : 0;
            }
            case 3: {
                return n;
            }
            case 4: {
                int n2 = responseHandler.resp.ContentLength;
                return n < (n2 -= responseHandler.stream.count) ? n : n2;
            }
            case 5: {
                return n;
            }
            case 6: {
                return n;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + responseHandler.resp.cd_type);
    }

    synchronized void close(IOException iOException, boolean bl) {
        if (this.Sock == null) {
            return;
        }
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: Closing all streams and socket (" + this.hashCode() + ")");
        }
        try {
            this.Stream.close();
        }
        catch (IOException iOException2) {
            // empty catch block
        }
        try {
            this.Sock.close();
        }
        catch (IOException iOException3) {
            // empty catch block
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (iOException != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(iOException, bl);
            }
        }
    }

    private void retry_requests(IOException iOException, boolean bl) {
        RetryException retryException = null;
        RetryException retryException2 = null;
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp.got_headers) {
                responseHandler.exception = iOException;
            } else {
                RetryException retryException3 = new RetryException(iOException.getMessage());
                if (retryException == null) {
                    retryException = retryException3;
                }
                retryException3.request = responseHandler.request;
                retryException3.response = responseHandler.resp;
                retryException3.exception = iOException;
                retryException3.conn_reset = bl;
                retryException3.first = retryException;
                retryException3.addToListAfter(retryException2);
                retryException2 = retryException3;
                responseHandler.exception = retryException3;
            }
            this.RespHandlerList.remove(responseHandler);
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    synchronized void close(ResponseHandler responseHandler) {
        if (responseHandler != (ResponseHandler)this.RespHandlerList.getFirst()) {
            return;
        }
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: Closing stream " + responseHandler.stream.hashCode() + " (" + Thread.currentThread() + ")");
        }
        responseHandler.eof = true;
        this.RespHandlerList.remove(responseHandler);
        if (responseHandler == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null && responseHandler.stream.closed) {
                if (responseHandler == this.MarkedForClose) {
                    ResponseHandler responseHandler2;
                    do {
                        responseHandler2 = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(responseHandler2);
                    } while (responseHandler2 != responseHandler);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    return;
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    synchronized void markForClose(Response response) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
        }
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        ResponseHandler responseHandler = null;
        ResponseHandler responseHandler2 = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler2 != null) {
            if (responseHandler2.resp == response) {
                this.MarkedForClose = responseHandler2;
                if (GlobalConstants.DebugDemux) {
                    System.err.println("Demux: stream " + response.inp_stream.hashCode() + " marked for close (" + Thread.currentThread() + ")");
                }
                this.closeSocketIfAllStreamsClosed();
                return;
            }
            if (this.MarkedForClose == responseHandler2) {
                return;
            }
            responseHandler = responseHandler2;
            responseHandler2 = (ResponseHandler)this.RespHandlerList.next();
        }
        if (responseHandler == null) {
            return;
        }
        this.MarkedForClose = responseHandler;
        this.closeSocketIfAllStreamsClosed();
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: stream " + responseHandler.stream.hashCode() + " marked for close (" + Thread.currentThread() + ")");
        }
    }

    void abort() {
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: Aborting socket (" + this.hashCode() + ")");
        }
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null) {
                if (responseHandler.resp.http_resp != null) {
                    responseHandler.resp.http_resp.markAborted();
                }
                if (responseHandler.exception == null) {
                    responseHandler.exception = new IOException("Request aborted by user");
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.Sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    public String toString() {
        String string;
        switch (this.Protocol) {
            case 0: {
                string = "HTTP";
                break;
            }
            case 1: {
                string = "HTTPS";
                break;
            }
            case 2: {
                string = "SHTTP";
                break;
            }
            case 3: {
                string = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + string + "]";
    }

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
    }
}

