/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.StreamDemultiplexor;

class SocketTimeout
extends Thread
implements GlobalConstants {
    private TimeoutEntry[] time_list;
    private int current;

    SocketTimeout(int n) {
        super("SocketTimeout");
        try {
            this.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setPriority(10);
        this.time_list = new TimeoutEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.time_list[n2] = new TimeoutEntry(null);
            this.time_list[n2].next = this.time_list[n2].prev = this.time_list[n2];
            ++n2;
        }
        this.current = 0;
    }

    public TimeoutEntry setTimeout(StreamDemultiplexor streamDemultiplexor) {
        TimeoutEntry timeoutEntry = new TimeoutEntry(streamDemultiplexor);
        TimeoutEntry[] timeoutEntryArray = this.time_list;
        synchronized (timeoutEntryArray) {
            timeoutEntry.next = this.time_list[this.current];
            timeoutEntry.prev = this.time_list[this.current].prev;
            timeoutEntry.prev.next = timeoutEntry;
            timeoutEntry.next.prev = timeoutEntry;
        }
        return timeoutEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        TimeoutEntry timeoutEntry = null;
        block4: while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TimeoutEntry[] timeoutEntryArray = this.time_list;
            synchronized (timeoutEntryArray) {
                TimeoutEntry timeoutEntry2 = this.time_list[this.current].next;
                while (timeoutEntry2 != this.time_list[this.current]) {
                    timeoutEntry2.restart = false;
                    timeoutEntry2 = timeoutEntry2.next;
                }
                ++this.current;
                if (this.current >= this.time_list.length) {
                    this.current = 0;
                }
                TimeoutEntry timeoutEntry3 = this.time_list[this.current].next;
                while (timeoutEntry3 != this.time_list[this.current]) {
                    if (timeoutEntry3.alive && !timeoutEntry3.hyber) {
                        TimeoutEntry timeoutEntry4 = timeoutEntry3.prev;
                        timeoutEntry3.kill();
                        timeoutEntry3.next = timeoutEntry;
                        timeoutEntry = timeoutEntry3;
                        timeoutEntry3 = timeoutEntry4;
                    }
                    timeoutEntry3 = timeoutEntry3.next;
                }
            }
            while (true) {
                if (timeoutEntry == null) continue block4;
                timeoutEntry.demux.markForClose(null);
                timeoutEntry = timeoutEntry.next;
            }
            break;
        }
    }

    class TimeoutEntry {
        boolean restart = false;
        boolean hyber = false;
        boolean alive = true;
        StreamDemultiplexor demux;
        TimeoutEntry next = null;
        TimeoutEntry prev = null;

        TimeoutEntry(StreamDemultiplexor streamDemultiplexor) {
            this.demux = streamDemultiplexor;
        }

        void reset() {
            this.hyber = false;
            if (this.restart) {
                return;
            }
            this.restart = true;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (timeoutEntryArray) {
                if (!this.alive) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.next = SocketTimeout.this.time_list[SocketTimeout.this.current];
                this.prev = ((SocketTimeout)SocketTimeout.this).time_list[((SocketTimeout)SocketTimeout.this).current].prev;
                this.prev.next = this;
                this.next.prev = this;
            }
        }

        void hyber() {
            if (this.alive) {
                this.hyber = true;
            }
        }

        void kill() {
            this.alive = false;
            this.restart = false;
            this.hyber = false;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (timeoutEntryArray) {
                if (this.prev == null) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = null;
            }
        }
    }
}

