/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient.datacomponents;

import java.awt.GridLayout;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import uk.org.iscream.cms.conient.datacomponents.DataFormatException;
import uk.org.iscream.cms.conient.datacomponents.VisibleDataComponent;
import uk.org.iscream.cms.server.util.XMLPacket;

public class UsersDataComponent
extends VisibleDataComponent {
    private String _name;
    private String _attribute;
    String _cache = "";
    protected JLabel _label;
    protected JComboBox _item = new JComboBox();

    public UsersDataComponent(String string, String string2) {
        this._name = string;
        this._attribute = string2;
        this._label = new JLabel(string + ": ");
        this._label.setHorizontalAlignment(4);
        this.setLayout(new GridLayout(1, 2));
        this._item.addItem("-uninitialised-");
        this.add(this._label);
        this.add(this._item);
        this.setVisible(false);
    }

    public void run() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this._item.removeAllItems();
        if (this._cache.equals(" ")) {
            this._item.addItem("no users logged on");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this._cache);
            while (stringTokenizer.hasMoreTokens()) {
                this._item.addItem(stringTokenizer.nextToken());
            }
        }
    }

    public String toString() {
        return this._name + "(" + this._attribute + ")";
    }

    public void setValue(XMLPacket xMLPacket) throws DataFormatException {
        String string = xMLPacket.getParam(this._attribute);
        try {
            if (!this._cache.equals(string)) {
                this._cache = string;
                SwingUtilities.invokeLater(this);
            }
        }
        catch (Exception exception) {
            throw new DataFormatException(string + " is an invalid data type for " + this.toString());
        }
    }

    public String getPacketAttribute() {
        return this._attribute;
    }
}

