/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient.datacomponents;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.org.iscream.cms.conient.datacomponents.DataFormatException;
import uk.org.iscream.cms.conient.datacomponents.VisibleDataComponent;
import uk.org.iscream.cms.server.util.XMLPacket;

public class StorageDataComponent
extends VisibleDataComponent {
    public final String REVISION = "$Revision: 1.4 $";
    protected String _name;
    protected String _attribute;
    protected String _maxAttribute;
    protected String _unit;
    protected int _divider;
    protected String _cache = "";
    protected String _maxcache = "";
    protected double _value = 0.0;
    protected double _maxvalue = 0.0;
    protected final int _min = 0;
    protected int _max = 0;
    protected JLabel _label;
    protected JProgressBar _item = new JProgressBar(0, 0, this._max);

    public StorageDataComponent(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, 1);
    }

    public StorageDataComponent(String string, String string2, String string3, String string4, int n) {
        this._item.setStringPainted(true);
        this._name = string;
        this._attribute = string2;
        this._unit = string4;
        this._divider = n;
        this._maxAttribute = string3;
        this._label = new JLabel(string + ": ");
        this._label.setHorizontalAlignment(4);
        this.setLayout(new GridLayout(1, 2));
        this._item.setString("-uninitialised-");
        this.add(this._label);
        this.add(this._item);
        this.setVisible(false);
    }

    public void run() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        int n = new Double(this._maxvalue).intValue();
        this._item.setMaximum(n);
        int n2 = new Double(this._value).intValue();
        this._item.setValue(n - n2);
        this._item.setString(n - n2 + this._unit + "/" + n + this._unit + " (" + new Double(this._item.getPercentComplete() * 100.0).intValue() + "%)");
    }

    public String toString() {
        return this._name + "(" + this._attribute + ")";
    }

    public void setValue(XMLPacket xMLPacket) throws DataFormatException {
        String string = xMLPacket.getParam(this._attribute);
        String string2 = xMLPacket.getParam(this._maxAttribute);
        try {
            if (!(string2.equals("0") || this._cache.equals(string) && this._maxcache.equals(string2))) {
                this._cache = string;
                this._maxcache = string2;
                this._value = Double.parseDouble(this._cache) / (double)this._divider;
                this._maxvalue = Double.parseDouble(this._maxcache) / (double)this._divider;
                SwingUtilities.invokeLater(this);
            }
        }
        catch (Exception exception) {
            throw new DataFormatException(string + " is an invalid data type for " + this.toString());
        }
    }

    public String getPacketAttribute() {
        return this._attribute;
    }
}

