/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import uk.org.iscream.cms.conient.Conient;
import uk.org.iscream.cms.conient.SwingSafeAdd;
import uk.org.iscream.cms.conient.datacomponents.DataComponent;
import uk.org.iscream.cms.conient.datacomponents.DataFormatException;
import uk.org.iscream.cms.conient.datacomponents.DateDataComponent;
import uk.org.iscream.cms.conient.datacomponents.StringDataComponent;
import uk.org.iscream.cms.server.util.XMLPacket;

public class QueueFrame
extends JFrame {
    public final String REVISION = "$Revision: 1.16 $";
    private HashMap _queues = new HashMap();
    private HashMap _queuesDisplays = new HashMap();
    private Box _content = Box.createVerticalBox();

    public QueueFrame() {
        super("Server Queue Status");
        JScrollPane jScrollPane = new JScrollPane(this._content, 20, 31);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JButton jButton = new JButton("Close Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)QueueFrame.this).setVisible(false);
            }
        });
        this.getContentPane().add((Component)jButton, "South");
        ((Frame)this).setIconImage(new ImageIcon("./resources/server.gif").getImage());
        this.pack();
        ((Component)this).setVisible(true);
    }

    public boolean update(XMLPacket xMLPacket) {
        boolean bl = true;
        String string = xMLPacket.getParam("packet.attributes.hashCode");
        if (!this._queues.containsKey(string)) {
            this.addQueue(xMLPacket);
        }
        try {
            this.updateQueueInformation(xMLPacket);
        }
        catch (DataFormatException dataFormatException) {
            Conient.addMessage("WARNING{queue frame}: " + dataFormatException.getMessage());
            bl = false;
        }
        return bl;
    }

    private void addQueue(XMLPacket xMLPacket) {
        HashMap<String, StringDataComponent> hashMap = new HashMap<String, StringDataComponent>();
        String string = xMLPacket.getParam("packet.attributes.name");
        String string2 = xMLPacket.getParam("packet.attributes.hashCode");
        DateDataComponent dateDataComponent = new DateDataComponent("Last timestamp", "packet.attributes.date");
        StringDataComponent stringDataComponent = new StringDataComponent("Total queued to date", "packet.queue.attributes.total");
        StringDataComponent stringDataComponent2 = new StringDataComponent("Maximum queue size", "packet.queue.attributes.maxSize");
        hashMap.put("packet.attributes.name", new StringDataComponent("Name", "packet.attributes.name"));
        hashMap.put("packet.queue.attributes.total", stringDataComponent);
        hashMap.put("packet.queue.attributes.maxSize", stringDataComponent2);
        hashMap.put("packet.attributes.date", dateDataComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 102)), string));
        jPanel.add(dateDataComponent);
        jPanel.add(stringDataComponent);
        jPanel.add(stringDataComponent2);
        this._queuesDisplays.put(string2, jPanel);
        try {
            SwingSafeAdd swingSafeAdd = new SwingSafeAdd(this._content, jPanel);
            SwingUtilities.invokeAndWait(swingSafeAdd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pack();
        this._queues.put(string2, hashMap);
    }

    private void updateQueueInformation(XMLPacket xMLPacket) throws DataFormatException {
        String string = xMLPacket.getParam("packet.attributes.hashCode");
        if (xMLPacket.getParam("packet.attributes.shutdown") != null) {
            JPanel jPanel = (JPanel)this._queuesDisplays.get(string);
            jPanel.setVisible(false);
            this._content.remove(jPanel);
            this._queuesDisplays.remove(jPanel);
            this.pack();
        } else {
            HashMap hashMap = (HashMap)this._queues.get(string);
            Set set = xMLPacket.getSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!hashMap.containsKey(string2) && string2.startsWith("packet.queue.attributes.queue")) {
                    StringDataComponent stringDataComponent = new StringDataComponent("Current length of " + string2.substring(string2.lastIndexOf(46) + 1), string2);
                    hashMap.put(string2, stringDataComponent);
                    try {
                        SwingSafeAdd swingSafeAdd = new SwingSafeAdd((JPanel)this._queuesDisplays.get(string), stringDataComponent);
                        SwingUtilities.invokeAndWait(swingSafeAdd);
                    }
                    catch (Exception exception) {
                        System.err.println("ERROR Failed To Add Component - " + exception);
                    }
                    this.pack();
                }
                if (!hashMap.containsKey(string2)) continue;
                ((DataComponent)hashMap.get(string2)).setValue(xMLPacket);
            }
        }
    }
}

