/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.Conient;
import uk.org.iscream.cms.conient.PacketTimer;
import uk.org.iscream.cms.conient.SwingSafeAdd;
import uk.org.iscream.cms.conient.datacomponents.CPUDataComponent;
import uk.org.iscream.cms.conient.datacomponents.DataComponent;
import uk.org.iscream.cms.conient.datacomponents.DataFormatException;
import uk.org.iscream.cms.conient.datacomponents.DateDataComponent;
import uk.org.iscream.cms.conient.datacomponents.DiskDataComponent;
import uk.org.iscream.cms.conient.datacomponents.ProcessesDataComponent;
import uk.org.iscream.cms.conient.datacomponents.ServiceDataComponent;
import uk.org.iscream.cms.conient.datacomponents.StorageDataComponent;
import uk.org.iscream.cms.conient.datacomponents.StringDataComponent;
import uk.org.iscream.cms.conient.datacomponents.UptimeDataComponent;
import uk.org.iscream.cms.conient.datacomponents.UsersDataComponent;
import uk.org.iscream.cms.conient.datacomponents.VisibleDataComponent;
import uk.org.iscream.cms.server.util.XMLPacket;

public class HostDisplayPanel
extends JPanel {
    public final String REVISION = "$Revision: 1.39 $";
    private HashMap _components = new HashMap();
    private final JPanel _north = new JPanel();
    private final JPanel _center = new JPanel();
    private final PacketTimer _heartbeatTimer;
    private final PacketTimer _dataTimer;
    private Thread _heartbeatTimerThread = null;
    private Thread _dataTimerThread = null;
    private final String _hostName;
    private final JPanel _disks = new JPanel();
    private final JPanel _extra;
    private final JPanel _services;
    private boolean _extraData;

    public HostDisplayPanel(String string) {
        this._disks.setLayout(new BoxLayout(this._disks, 1));
        this._extra = new JPanel();
        this._extra.setLayout(new BoxLayout(this._extra, 1));
        this._services = new JPanel();
        this._services.setLayout(new BoxLayout(this._services, 1));
        this._extraData = false;
        this.setLayout(new BorderLayout());
        this._hostName = string;
        if (Configuration.getInstance().getProperty("displayExtraData").equals("1")) {
            this._extraData = true;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this._center.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.add(this._center);
        this.add((Component)jPanel, "Center");
        this.add((Component)this._north, "North");
        this.addDataComponent(new StringDataComponent("Packet Type", "packet.attributes.type"));
        final StringDataComponent stringDataComponent = new StringDataComponent("Host Name", "packet.attributes.machine_name");
        this.addDataComponent(stringDataComponent);
        final StringDataComponent stringDataComponent2 = new StringDataComponent("IP Address", "packet.attributes.ip");
        this.addDataComponent(stringDataComponent2);
        final UptimeDataComponent uptimeDataComponent = new UptimeDataComponent("Uptime", "packet.os.uptime");
        this.addDataComponent(uptimeDataComponent);
        final StringDataComponent stringDataComponent3 = new StringDataComponent("Packets since host started", "packet.attributes.seq_no");
        this.addDataComponent(stringDataComponent3);
        final StringDataComponent stringDataComponent4 = new StringDataComponent("Operating System", "packet.os.name");
        this.addDataComponent(stringDataComponent4);
        final StringDataComponent stringDataComponent5 = new StringDataComponent("Operating System Version", "packet.os.version");
        this.addDataComponent(stringDataComponent5);
        final StringDataComponent stringDataComponent6 = new StringDataComponent("Operating System Release", "packet.os.release");
        this.addDataComponent(stringDataComponent6);
        final StringDataComponent stringDataComponent7 = new StringDataComponent("System Name", "packet.os.sysname");
        this.addDataComponent(stringDataComponent7);
        final StringDataComponent stringDataComponent8 = new StringDataComponent("NetBIOS Name", "packet.os.netbios_name");
        this.addDataComponent(stringDataComponent8);
        final StringDataComponent stringDataComponent9 = new StringDataComponent("System Architecture", "packet.os.platform");
        this.addDataComponent(stringDataComponent9);
        JButton jButton = new JButton("Platform Information");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Host platform information for - " + HostDisplayPanel.this._hostName);
                Box box = Box.createVerticalBox();
                box.add(stringDataComponent);
                box.add(stringDataComponent2);
                box.add(uptimeDataComponent);
                box.add(stringDataComponent3);
                box.add(stringDataComponent4);
                box.add(stringDataComponent5);
                box.add(stringDataComponent6);
                box.add(stringDataComponent7);
                box.add(stringDataComponent8);
                box.add(stringDataComponent9);
                jFrame.getContentPane().add((Component)box, "Center");
                JButton jButton = new JButton("Close Window");
                jButton.addActionListener(new ActionListener(this, jFrame){
                    private final /* synthetic */ JFrame val$infoFrame;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$infoFrame = jFrame;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$infoFrame.dispose();
                    }
                });
                jFrame.getContentPane().add((Component)jButton, "South");
                ((Frame)jFrame).setIconImage(new ImageIcon("./resources/server.gif").getImage());
                jFrame.pack();
                ((Component)jFrame).setVisible(true);
            }
        });
        try {
            this._heartbeatTimer = new PacketTimer("Next Heartbeat", Integer.parseInt(Configuration.getInstance().getServerProperty("Host." + string, "Host.TCPUpdateTime")));
            this._dataTimer = new PacketTimer("Next Data", Integer.parseInt(Configuration.getInstance().getServerProperty("Host." + string, "Host.UDPUpdateTime")));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("unable to obtain a valid value for Host.UDP/TCPUpdateTime");
        }
        this._north.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(new JLabel("Showing data from - " + string, 0));
        this._north.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 3));
        jPanel3.add(this._dataTimer);
        jPanel3.add(jButton);
        jPanel3.add(this._heartbeatTimer);
        this._north.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        this.addVisibleDataComponent(jPanel4, new DateDataComponent("Host Time", "packet.attributes.date"));
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this._center.add(jPanel4);
        JLabel jLabel = new JLabel("--- CPU ---", 0);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.addVisibleDataComponent(jPanel5, new CPUDataComponent("CPU Idle", "packet.cpu.idle"));
        this.addVisibleDataComponent(jPanel5, new CPUDataComponent("CPU User", "packet.cpu.user"));
        this.addVisibleDataComponent(jPanel5, new CPUDataComponent("CPU Kernel", "packet.cpu.kernel"));
        this.addVisibleDataComponent(jPanel5, new CPUDataComponent("CPU i/o wait", "packet.cpu.iowait"));
        this.addVisibleDataComponent(jPanel5, new CPUDataComponent("CPU swapping", "packet.cpu.swap"));
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        this._center.add(jPanel5);
        jLabel = new JLabel("--- Load ---", 0);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        Box box = Box.createHorizontalBox();
        this.addVisibleDataComponent(box, new ProcessesDataComponent("1 minute", "packet.load.load1"));
        this.addVisibleDataComponent(box, new ProcessesDataComponent("5 minutes", "packet.load.load5"));
        this.addVisibleDataComponent(box, new ProcessesDataComponent("15 minutes", "packet.load.load15"));
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        this._center.add(box);
        jLabel = new JLabel("--- Processes ---", 0);
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        Box box2 = Box.createHorizontalBox();
        this.addVisibleDataComponent(box2, new ProcessesDataComponent("Total", "packet.processes.total"));
        this.addVisibleDataComponent(box2, new ProcessesDataComponent("Running", "packet.processes.cpu"));
        this.addVisibleDataComponent(box2, new ProcessesDataComponent("Sleeping", "packet.processes.sleeping"));
        this.addVisibleDataComponent(box2, new ProcessesDataComponent("Stopped", "packet.processes.stopped"));
        this.addVisibleDataComponent(box2, new ProcessesDataComponent("Zombie", "packet.processes.zombie"));
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(box2, gridBagConstraints);
        this._center.add(box2);
        jLabel = new JLabel("--- Memory ---", 0);
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        this.addVisibleDataComponent(jPanel6, new StorageDataComponent("Memory in use", "packet.memory.free", "packet.memory.total", "Mb"));
        this.addVisibleDataComponent(jPanel6, new StorageDataComponent("Swap in use", "packet.swap.free", "packet.swap.total", "Mb"));
        this.addDataComponent(new StringDataComponent("packet.memory.total", "packet.memory.total"));
        this.addDataComponent(new StringDataComponent("packet.swap.total", "packet.swap.total"));
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        this._center.add(jPanel6);
        jLabel = new JLabel("--- Users ---", 0);
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        this.addVisibleDataComponent(jPanel7, new StringDataComponent("Number of users", "packet.users.count"));
        UsersDataComponent usersDataComponent = new UsersDataComponent("User List", "packet.users.list");
        this.addVisibleDataComponent(jPanel7, usersDataComponent);
        gridBagConstraints.gridy = 10;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        this._center.add(jPanel7);
        jLabel = new JLabel("--- Disks ---", 0);
        gridBagConstraints.gridy = 11;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        gridBagConstraints.gridy = 12;
        gridBagLayout.setConstraints(this._disks, gridBagConstraints);
        this._center.add(this._disks);
        jLabel = new JLabel("--- System Services ---", 0);
        gridBagConstraints.gridy = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._center.add(jLabel);
        gridBagConstraints.gridy = 14;
        gridBagLayout.setConstraints(this._services, gridBagConstraints);
        this._center.add(this._services);
        if (this._extraData) {
            jLabel = new JLabel("--- Extra Data ---", 0);
            gridBagConstraints.gridy = 15;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this._center.add(jLabel);
            gridBagConstraints.gridy = 16;
            gridBagLayout.setConstraints(this._extra, gridBagConstraints);
            this._center.add(this._extra);
        }
        gridBagConstraints.gridy = 17;
        Component component = Box.createRigidArea(new Dimension(468, 30));
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this._center.add(component);
        gridBagConstraints.gridy = 18;
        JLabel jLabel2 = new JLabel(new ImageIcon("./resources/banner3.gif"));
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this._center.add(jLabel2);
    }

    public boolean updateHost(XMLPacket xMLPacket) {
        boolean bl = true;
        if (xMLPacket.getParam("packet.attributes.type").equals("heartbeat")) {
            this._heartbeatTimer.reset();
            if (this._heartbeatTimerThread == null) {
                this._heartbeatTimerThread = new Thread(this._heartbeatTimer);
                this._heartbeatTimerThread.start();
            }
            bl = this.processPacket(xMLPacket);
        } else if (xMLPacket.getParam("packet.attributes.type").equals("data")) {
            bl = this.processPacket(xMLPacket);
            this._dataTimer.reset();
            if (this._dataTimerThread == null) {
                this._dataTimerThread = new Thread(this._dataTimer);
                this._dataTimerThread.start();
            }
        }
        return bl;
    }

    private boolean processPacket(XMLPacket xMLPacket) {
        boolean bl = true;
        Set set = xMLPacket.getSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this._components.containsKey(string)) {
                if (string.startsWith("packet.disk.p")) {
                    this.createDiskPanel(string);
                } else if (string.startsWith("packet.services.")) {
                    this.createServicesPanel(string);
                } else if (this._extraData) {
                    this.addVisibleDataComponent(this._extra, new StringDataComponent(string, string));
                }
            }
            if (!this._components.containsKey(string)) continue;
            try {
                ((DataComponent)this._components.get(string)).setValue(xMLPacket);
            }
            catch (DataFormatException dataFormatException) {
                Conient.addMessage("WARNING{host display}: " + dataFormatException.getMessage());
                bl = false;
            }
        }
        return bl;
    }

    private void addDataComponent(DataComponent dataComponent) {
        this._components.put(dataComponent.getPacketAttribute(), dataComponent);
    }

    public void addVisibleDataComponent(Container container, VisibleDataComponent visibleDataComponent) {
        this._components.put(visibleDataComponent.getPacketAttribute(), visibleDataComponent);
        SwingSafeAdd swingSafeAdd = new SwingSafeAdd(container, visibleDataComponent);
        SwingUtilities.invokeLater(swingSafeAdd);
    }

    private void createDiskPanel(String string) {
        String string2 = "";
        int n = 13;
        while (string.charAt(n) != '.') {
            string2 = string2 + string.charAt(n);
            ++n;
        }
        String string3 = "packet.disk.p" + string2 + ".attributes.name";
        String string4 = "packet.disk.p" + string2 + ".attributes.mount";
        String string5 = "packet.disk.p" + string2 + ".attributes.kbytes";
        String string6 = "packet.disk.p" + string2 + ".attributes.avail";
        DiskDataComponent diskDataComponent = new DiskDataComponent("Disk", string6, string5, string4, string3, "Mb", 1024);
        this.addVisibleDataComponent(this._disks, diskDataComponent);
        this.addDataComponent(new StringDataComponent(string3, string3));
        this.addDataComponent(new StringDataComponent(string4, string4));
        this.addDataComponent(new StringDataComponent(string5, string5));
        this.addDataComponent(new StringDataComponent("packet.disk.p" + string2 + ".used", "packet.disk.p" + string2 + ".attributes.used"));
    }

    private void createServicesPanel(String string) {
        String string2 = "";
        int n = 16;
        while (string.charAt(n) != '.') {
            string2 = string2 + string.charAt(n);
            ++n;
        }
        String string3 = "packet.services." + string2 + ".attributes.status";
        this.addDataComponent(new StringDataComponent(string2 + " service status", string3));
        ServiceDataComponent serviceDataComponent = new ServiceDataComponent(string2, "packet.services." + string2 + ".attributes.message", string3);
        this.addVisibleDataComponent(this._services, serviceDataComponent);
    }
}

