/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.ConnectionHandler;
import uk.org.iscream.cms.conient.DataPanel;
import uk.org.iscream.cms.server.util.Queue;

public class ControlPanel
extends JPanel {
    public final String REVISION = "$Revision: 1.14 $";
    JToolBar _toolBar = this.setupToolBar();
    JMenuBar _menuBar = this.setupMenuBar();
    Queue _actionQueue = new Queue();
    ConnectionHandler _handler;

    public ControlPanel(DataPanel dataPanel) {
        this.setLayout(new BorderLayout());
        this._handler = new ConnectionHandler(dataPanel, this._actionQueue);
        this.add((Component)this._toolBar, "North");
        this._handler.start();
    }

    private JToolBar setupToolBar() {
        JButton jButton = new JButton("Connect", new ImageIcon("./resources/control16.gif"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(1));
            }
        });
        JButton jButton2 = new JButton("Disconnect", new ImageIcon("./resources/stop16.gif"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(4));
            }
        });
        JButton jButton3 = new JButton("Start Data", new ImageIcon("./resources/data16.gif"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(2));
            }
        });
        JButton jButton4 = new JButton("Stop Data", new ImageIcon("./resources/stop16.gif"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(3));
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.add(Box.createGlue());
        JLabel jLabel = new JLabel(new ImageIcon("./resources/i-scream.gif"));
        jToolBar.add(jLabel);
        return jToolBar;
    }

    public JMenuBar setupMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Conient");
        JMenuItem jMenuItem = new JMenuItem("Modifiy Configuration");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.getInstance().GUIReconfiguration();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Save Configuration");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Configuration.getInstance().getUsingSpecificConfig()) {
                    Configuration.getInstance().saveConfiguration();
                } else {
                    Configuration.getInstance().saveNewConfiguration();
                }
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save Configuration As...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.getInstance().saveNewConfiguration();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Save Configuration As Default");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.getInstance().saveDefaultConfiguration();
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Load Configuration...");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.getInstance().loadConfiguration();
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Quit");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(5));
            }
        });
        jMenu.add(jMenuItem6);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Connection");
        JMenuItem jMenuItem7 = new JMenuItem("Connect", new ImageIcon("./resources/control16.gif"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(1));
            }
        });
        jMenu2.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Disconnect", new ImageIcon("./resources/stop16.gif"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(4));
            }
        });
        jMenu2.add(jMenuItem8);
        jMenu2.addSeparator();
        JMenuItem jMenuItem9 = new JMenuItem("Start Data", new ImageIcon("./resources/data16.gif"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(2));
            }
        });
        jMenu2.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Stop Data", new ImageIcon("./resources/stop16.gif"));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this._actionQueue.add(new Integer(3));
            }
        });
        jMenu2.add(jMenuItem10);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    public JMenuBar getMenuBar() {
        return this._menuBar;
    }
}

