/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.Conient;
import uk.org.iscream.cms.conient.DataPanel;
import uk.org.iscream.cms.conient.DataReader;
import uk.org.iscream.cms.conient.TunnelProcess;
import uk.org.iscream.cms.server.util.InvalidQueueException;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.StringUtils;

public class ConnectionHandler
extends Thread {
    public final String REVISION = "$Revision: 1.33 $";
    public final double PROTOCOL_VERSION = 1.1;
    public static final int DONOTHING = 0;
    public static final int CONNECT = 1;
    public static final int STARTDATA = 2;
    public static final int STOPDATA = 3;
    public static final int DISCONNECT = 4;
    public static final int QUIT = 5;
    public static final int GETCONFIGURATION = 6;
    public static final int DATAREADER_SHUTDOWN_TIMEOUT = 5;
    public static final String DEFAULT_FIREWALL_SERVER = "localhost";
    public static final int DEFAULT_FIREWALL_COMMANDWAIT = 5;
    public static final int DEFAULT_QUEUE_LIMIT = 500;
    public static final int QUEUE_ALGORITHM = 1;
    private boolean _running = true;
    private DataPanel _data;
    private Queue _actionQueue;
    private int _myQueue;
    private Socket _controlLink;
    private Socket _dataLink;
    private BufferedReader _inBound;
    private PrintWriter _outBound;
    private BufferedReader _dataInBound;
    private PrintWriter _dataOutBound;
    private DataReader _dataReader;
    private Configuration _configuration = Configuration.getInstance();
    private String _server = null;
    private String _configuredServer = null;
    private TunnelProcess _controlFirewallProcess = new TunnelProcess();
    private TunnelProcess _dataFirewallProcess = new TunnelProcess();

    public ConnectionHandler(DataPanel dataPanel, Queue queue) {
        this._data = dataPanel;
        this._actionQueue = queue;
        this._myQueue = this._actionQueue.getQueue();
        this._configuration.setConnectionHandler(this);
    }

    public void run() {
        if (this._configuration.getProperty("control.onstartconnect").equals("1")) {
            this._actionQueue.add(new Integer(1));
        }
        if (this._configuration.getProperty("data.onstartconnect").equals("1")) {
            this._actionQueue.add(new Integer(2));
        }
        block29: while (this._running) {
            int n = 0;
            try {
                n = (Integer)this._actionQueue.get(this._myQueue);
            }
            catch (InvalidQueueException invalidQueueException) {
                throw new RuntimeException("unable to retrieve events from actionQueue!");
            }
            switch (n) {
                case 1: {
                    String string;
                    if (this._controlLink == null) {
                        try {
                            this._configuredServer = this._configuration.getProperty("control.server");
                            if (this._configuredServer == null) {
                                throw new IOException("no i-scream server in current configuration");
                            }
                            string = this._configuration.getProperty("control.port");
                            if (string == null) {
                                throw new IOException("no i-scream server port in current configuration");
                            }
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IOException("no valid i-scream server port in current configuration");
                            }
                            this._server = this.handleFirewall(this._configuredServer, n2, this._controlFirewallProcess);
                            Conient.setControlStatus("Connecting to - " + this._server);
                            this._controlLink = new Socket(this._server, n2);
                            this._inBound = new BufferedReader(new InputStreamReader(this._controlLink.getInputStream()));
                            this._outBound = new PrintWriter(this._controlLink.getOutputStream());
                            Conient.setControlStatus("Connection Established - " + this._server);
                            String string2 = this._inBound.readLine();
                            double d = Double.parseDouble(string2.substring(9, string2.length()));
                            Conient.addMessage("Protocol Versions: server [" + d + "] client [" + 1.1 + "]");
                            if (d > 1.1) {
                                Conient.addMessage("WARNING{control link}: server is using a newer protocol (" + string2 + "), please update your client, continuing with old protocol (PROTOCOL " + 1.1 + ")");
                            } else if (d < 1.1) {
                                throw new IOException("incompatible protocol version");
                            }
                            this._outBound.println(this._configuration.getProperty("clientname"));
                            this._outBound.flush();
                            string2 = this._inBound.readLine();
                            if (string2.equals("OK")) continue block29;
                            throw new IOException("client name rejected - " + this._configuration.getProperty("clientname"));
                        }
                        catch (IOException iOException) {
                            Conient.addMessage("ERROR{control link}: " + iOException);
                            this._controlLink = null;
                            this.closeFirewall(this._controlFirewallProcess);
                            this._actionQueue.clearQueue(this._myQueue);
                            Conient.setControlStatus("Disconnected");
                        }
                        continue block29;
                    }
                    Conient.addMessage("WARNING{control link}: already established");
                    break;
                }
                case 2: {
                    String string;
                    if (this._dataLink == null) {
                        if (this._controlLink == null) {
                            Conient.addMessage("WARNING{data link}: control link not established - queueing start events");
                            this._actionQueue.add(new Integer(1));
                            this._actionQueue.add(new Integer(2));
                            break;
                        }
                        try {
                            string = this._configuration.getProperty("hostList");
                            boolean bl = false;
                            if (this._configuration.getProperty("useHostList").equals("1")) {
                                if (string.equals("")) {
                                    Conient.addMessage("WARNING{control link}: your host list is empty, the server will send ALL hosts");
                                }
                                bl = this.setHostList(string);
                            } else {
                                bl = this.setHostList("");
                            }
                            if (!bl) {
                                Conient.addMessage("WARNING{control link}: unable to set host list");
                            }
                            this._outBound.println("STARTDATA");
                            this._outBound.flush();
                            String string3 = this._inBound.readLine();
                            if (string3.equals("ERROR")) {
                                throw new IOException("server unable to start data link at this time");
                            }
                            int n3 = 0;
                            try {
                                n3 = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IOException("invalid data port suggested by server - " + string3);
                            }
                            this._server = this.handleFirewall(this._configuredServer, n3, this._dataFirewallProcess);
                            Conient.setDataStatus("Connecting to - " + this._server + ":" + string3);
                            this._dataLink = new Socket(this._server, n3);
                            string3 = this._inBound.readLine();
                            if (!string3.equals("OK")) {
                                throw new IOException("server reported error establishing data channel");
                            }
                            this._dataInBound = new BufferedReader(new InputStreamReader(this._dataLink.getInputStream()));
                            this._dataOutBound = new PrintWriter(this._dataLink.getOutputStream());
                            Conient.setDataStatus("Connection Established - " + this._server);
                            String string4 = this._configuration.getProperty("dataQueueSize");
                            int n4 = 500;
                            if (string4 != null) {
                                try {
                                    n4 = Integer.parseInt(string4);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Conient.addMessage("WARNING{data link}: invalid queue size in configuration, using default of - " + n4);
                                }
                            }
                            Queue queue = new Queue(n4, 1);
                            this._dataReader = new DataReader(this._dataInBound, queue, this);
                            this._data.setQueue(queue);
                            this._data.cleanUpTabs();
                            new Thread(this._data).start();
                            this._dataReader.start();
                        }
                        catch (IOException iOException) {
                            Conient.addMessage("ERROR{data link}: " + iOException);
                            this._dataLink = null;
                            this.closeFirewall(this._dataFirewallProcess);
                            this._actionQueue.clearQueue(this._myQueue);
                            Conient.setDataStatus("Disconnected");
                        }
                        continue block29;
                    }
                    Conient.addMessage("WARNING{data link}: already established");
                    break;
                }
                case 3: {
                    String string;
                    if (this._dataLink != null) {
                        try {
                            Conient.setDataStatus("Disconnecting - " + this._server);
                            this._dataReader.shutdown();
                            boolean bl = true;
                            long l = System.currentTimeMillis();
                            while (System.currentTimeMillis() - l < 5000L) {
                                if (this._dataReader.isAlive()) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                Conient.addMessage("WARNING{data link}: data reader thread did not close within timeout, killing its IO anyway!");
                            }
                            this._outBound.println("STOPDATA");
                            this._outBound.flush();
                            string = this._inBound.readLine();
                            if (!string.equals("OK")) {
                                throw new IOException("server didn't OK request to stop data channel - stopping anyway");
                            }
                            this._dataInBound.close();
                            this._dataOutBound.close();
                            this._dataLink.close();
                            this._dataLink = null;
                            this.closeFirewall(this._dataFirewallProcess);
                            Conient.setDataStatus("Disconnected");
                        }
                        catch (IOException iOException) {
                            Conient.addMessage("ERROR{data link}: " + iOException);
                            try {
                                this._dataOutBound.close();
                                this._dataInBound.close();
                                this._dataLink.close();
                                this.closeFirewall(this._dataFirewallProcess);
                            }
                            catch (IOException iOException2) {
                                Conient.addMessage("CRITICAL{control link}: unable to close socket - " + iOException2);
                            }
                            this._dataLink = null;
                            this._actionQueue.clearQueue(this._myQueue);
                            Conient.setDataStatus("Disconnected");
                        }
                        continue block29;
                    }
                    Conient.addMessage("WARNING{data link}: already disconnected");
                    break;
                }
                case 4: {
                    String string;
                    if (this._controlLink != null) {
                        if (this._dataLink != null) {
                            Conient.addMessage("WARNING{control link}: data link not disconnected - queueing stop events");
                            this._actionQueue.add(new Integer(3));
                            this._actionQueue.add(new Integer(4));
                            break;
                        }
                        try {
                            this._outBound.println("DISCONNECT");
                            this._outBound.flush();
                            string = this._inBound.readLine();
                            if (!string.equals("OK")) {
                                throw new IOException("server didn't OK request to stop control channel - stopping anyway");
                            }
                            Conient.setControlStatus("Disconnecting - " + this._server);
                            this._inBound.close();
                            this._outBound.close();
                            this._controlLink.close();
                            this._controlLink = null;
                            this.closeFirewall(this._controlFirewallProcess);
                            Conient.setControlStatus("Disconnected");
                        }
                        catch (IOException iOException) {
                            Conient.addMessage("ERROR{control link}: " + iOException);
                            try {
                                this._inBound.close();
                                this._outBound.close();
                                this._controlLink.close();
                                this.closeFirewall(this._controlFirewallProcess);
                            }
                            catch (IOException iOException3) {
                                Conient.addMessage("CRITICAL{control link}: unable to close socket - " + iOException3);
                            }
                            this._controlLink = null;
                            this._actionQueue.clearQueue(this._myQueue);
                            Conient.setControlStatus("Disconnected");
                        }
                        continue block29;
                    }
                    Conient.addMessage("WARNING{control link}: already disconnected");
                    break;
                }
                case 5: {
                    Conient.addMessage("Exiting.");
                    try {
                        if (this._dataLink != null) {
                            this._actionQueue.add(new Integer(3));
                            this._actionQueue.add(new Integer(4));
                            this._actionQueue.add(new Integer(5));
                            throw new IOException();
                        }
                        if (this._controlLink != null) {
                            this._actionQueue.add(new Integer(4));
                            this._actionQueue.add(new Integer(5));
                            throw new IOException();
                        }
                        Conient.addMessage("Finished.");
                        System.exit(0);
                        break;
                    }
                    catch (IOException iOException) {
                        Conient.addMessage("WARNING: open connections detected - queueing stop events");
                    }
                }
            }
        }
    }

    public String getConfigFromServer(String string, String string2) {
        String string3 = "";
        if (this._controlLink != null) {
            try {
                Conient.addMessage("Getting configuration from server");
                String string4 = null;
                this._outBound.println("STARTCONFIG");
                this._outBound.flush();
                string4 = this._inBound.readLine();
                if (!string4.equals("OK")) {
                    throw new IOException("server refused (" + string4 + ")");
                }
                this._outBound.println(string + ";" + string2);
                this._outBound.flush();
                string4 = this._inBound.readLine();
                if (string4.equals("ERROR")) {
                    throw new IOException("server did not returned ERROR");
                }
                string3 = string4;
                this._outBound.println("ENDCONFIG");
                this._outBound.flush();
                string4 = this._inBound.readLine();
                if (!string4.equals("OK")) {
                    throw new IOException("server reported error when finishing configuration");
                }
            }
            catch (IOException iOException) {
                Conient.addMessage("ERROR{control link}: when getting configuration - " + iOException);
            }
        }
        return string3;
    }

    public void shutdown() {
        this._running = false;
    }

    public void shutdownDataLink() {
        this._actionQueue.add(new Integer(3));
    }

    private boolean setHostList(String string) {
        boolean bl = false;
        if (this._controlLink != null && this._dataLink == null) {
            try {
                Conient.addMessage("Setting host list to:" + string);
                String string2 = null;
                this._outBound.println("SETHOSTLIST");
                this._outBound.flush();
                string2 = this._inBound.readLine();
                if (!string2.equals("OK")) {
                    throw new IOException("server refused - data link possibly still open?");
                }
                this._outBound.println(string);
                this._outBound.flush();
                string2 = this._inBound.readLine();
                if (!string2.equals("OK")) {
                    throw new IOException("server had trouble with our request");
                }
                bl = true;
            }
            catch (IOException iOException) {
                Conient.addMessage("ERROR{control link}: when setting hostlist - " + iOException);
            }
        }
        return bl;
    }

    private String handleFirewall(String string, int n, TunnelProcess tunnelProcess) {
        String string2 = this._configuration.getProperty("firewall.command");
        String string3 = this._configuration.getProperty("useFirewall");
        String string4 = this._configuration.getProperty("firewall.commandwait");
        String string5 = this._configuration.getProperty("firewall.server");
        if (string3.equals("1")) {
            string2 = StringUtils.replaceText(string2, "%PORT%", new Integer(n).toString());
            string2 = StringUtils.replaceText(string2, "%SERVER%", string);
            Conient.addMessage("WARNING{firewall}: firewall pipes requested, running pipe setup command \"" + string2 + "\"");
            try {
                tunnelProcess.setProcess(Runtime.getRuntime().exec(string2));
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    n2 = 5;
                }
                Conient.addMessage("WARNING{firewall}: waiting " + n2 + " seconds for command to complete!");
                try {
                    Thread.sleep(n2 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                string = string5;
                if (string.equals("")) {
                    string = DEFAULT_FIREWALL_SERVER;
                }
            }
            catch (IOException iOException) {
                Conient.addMessage("ERROR{firewall}: unable to start pipe to i-scream server");
            }
        }
        return string;
    }

    private void closeFirewall(TunnelProcess tunnelProcess) {
        if (tunnelProcess.getProcess() != null) {
            tunnelProcess.getProcess().destroy();
            tunnelProcess.setProcess(null);
            Conient.addMessage("WARNING{firewall}: firewall process destroyed");
        }
    }
}

