/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.ControlPanel;
import uk.org.iscream.cms.conient.DataPanel;

public class Conient
extends JFrame {
    public final String REVISION = "$Revision: 1.31 $";
    private final int DEFAULT_WIDTH = 700;
    private final int DEFAULT_HEIGHT = 600;
    public static final String DEFAULT_CONFIG_FILE = "./etc/default.conf";
    public static final int DISPLAY_SPLASH_TIME_SECONDS = 3;
    static JLabel _controlStatus = new JLabel("Control Link: Disconnected", 2);
    static JLabel _dataStatus = new JLabel("Data Link: Disconnected", 2);
    static JLabel _queueStatus = new JLabel(" ", 2);
    static JTextArea _messages = new JTextArea();
    private static Frame conientFrame;

    public static void main(String[] stringArray) {
        Object var1_1 = null;
        String string = DEFAULT_CONFIG_FILE;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration.initialise(string);
        DataPanel dataPanel = new DataPanel();
        ControlPanel controlPanel = new ControlPanel(dataPanel);
        Conient conient = new Conient(dataPanel, controlPanel);
        conientFrame = conient;
        Conient.addMessage("Conient {an i-scream Client} (c) 2001 The i-scream Project (http://www.i-scream.org.uk)");
        Conient.addMessage("Conient ready.");
    }

    public static Frame getFrame() {
        return conientFrame;
    }

    private Conient(JSplitPane jSplitPane, ControlPanel controlPanel) {
        super("Conient {an i-scream Client}");
        _controlStatus.setBorder(new EtchedBorder(1));
        _dataStatus.setBorder(new EtchedBorder(1));
        _queueStatus.setBorder(new EtchedBorder(1));
        _messages.setLineWrap(true);
        ((Component)this).setSize(700, 600);
        this.setJMenuBar(controlPanel.getMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add((Component)controlPanel, "North");
        this.getContentPane().add(jSplitPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        _messages.setEditable(false);
        _messages.setRows(3);
        JScrollPane jScrollPane = new JScrollPane(_messages);
        jScrollPane.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 102)), " Messages "));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(_controlStatus);
        jPanel3.add(_dataStatus);
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(_queueStatus);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel, "South");
        ((Frame)this).setIconImage(new ImageIcon("./resources/server.gif").getImage());
        Splash splash = new Splash();
        splash.show();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        splash.dispose();
        splash = null;
        this.show();
    }

    public static void setControlStatus(String string) {
        _controlStatus.setText("Control Link: " + string);
        _controlStatus.repaint();
    }

    public static void setDataStatus(String string) {
        _dataStatus.setText("Data Link: " + string);
        _dataStatus.repaint();
    }

    public static void setQueueStatus(int n, int n2) {
        _queueStatus.setText("Data Queue : " + n + " Packets Recieved : " + n2);
        _queueStatus.repaint();
    }

    public static void addMessage(String string) {
        _messages.insert(string + "\n", 0);
    }

    private class Splash
    extends JWindow {
        public Splash() {
            this.setCursor(Cursor.getPredefinedCursor(3));
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.black);
            JLabel jLabel = new JLabel(new ImageIcon("./resources/i-scream-splash.gif"));
            jPanel.add(jLabel);
            this.setContentPane(jPanel);
            Dimension dimension = this.getToolkit().getScreenSize();
            this.pack();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
    }
}

