/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.Conient;

public class ConfigurationDialog
extends JDialog {
    public static final String REVISION = "$Revision: 1.14 $";
    Configuration _config = Configuration.getInstance();
    private JTextField _newHost;
    private JList _knownHosts;
    private JList _hostList;
    private JCheckBox _hostDiscoveryMode;
    private JCheckBox _useHostList;
    private JTextField _name;
    private JTextField _port;
    private JTextField _server;
    private JCheckBox _connectControl;
    private JCheckBox _connectData;
    private JCheckBox _useFirewall;
    private JTextField _firewallCommand;
    private JTextField _firewallWait;
    private JTextField _firewallServer;
    private JCheckBox _displayQueue;
    private JCheckBox _displayExtra;
    private JCheckBox _packetDump;
    private JTextField _queueLimit;
    private ArrayList _knownHostsData;
    private ArrayList _hostListData;

    public ConfigurationDialog() {
        super(Conient.getFrame(), "Configuration Options", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.setNewSettingsAndClose();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dispose();
            }
        });
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Client Options", this.createClientOptions());
        jTabbedPane.addTab("Server Options", this.createServerOptions());
        jTabbedPane.addTab("Firewall Options", this.createFirewallOptions());
        jTabbedPane.addTab("Data Options", this.createDataOptions());
        this.getCurrentSettings();
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.pack();
        this.setLocationRelativeTo(Conient.getFrame());
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel createClientOptions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Client name:");
        jLabel.setHorizontalAlignment(4);
        this._name = new JTextField(20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jLabel);
        jPanel2.add(this._name);
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this._hostDiscoveryMode = new JCheckBox("Discover new hosts from the server");
        jPanel4.add(this._hostDiscoveryMode);
        jPanel4.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 102)), " Known Hosts "));
        this._knownHosts = new JList();
        this._knownHosts.setVisibleRowCount(10);
        JScrollPane jScrollPane = new JScrollPane(this._knownHosts);
        jPanel4.add(jScrollPane);
        JLabel jLabel2 = new JLabel("New host:");
        jLabel2.setHorizontalAlignment(4);
        this._newHost = new JTextField(20);
        JButton jButton = new JButton("Add Host");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this._knownHostsData.add(ConfigurationDialog.this._newHost.getText());
                ConfigurationDialog.this._newHost.setText("");
                ConfigurationDialog.this.setListDisplay();
            }
        });
        JButton jButton2 = new JButton("Remove Host(s)");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ConfigurationDialog.this._knownHosts.getSelectedValues();
                int n = 0;
                while (n < objectArray.length) {
                    ConfigurationDialog.this._knownHostsData.remove(ConfigurationDialog.this._knownHostsData.indexOf(objectArray[n]));
                    ConfigurationDialog.this.setListDisplay();
                    ++n;
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 3));
        jPanel5.add(jLabel2);
        jPanel5.add(this._newHost);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(Box.createGlue());
        JButton jButton3 = new JButton(">>>");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ConfigurationDialog.this._knownHosts.getSelectedValues();
                int n = 0;
                while (n < objectArray.length) {
                    ConfigurationDialog.this._knownHostsData.remove(ConfigurationDialog.this._knownHostsData.indexOf(objectArray[n]));
                    ConfigurationDialog.this._hostListData.add(objectArray[n]);
                    ConfigurationDialog.this.setListDisplay();
                    ++n;
                }
            }
        });
        jPanel7.add(jButton3);
        jPanel7.add(Box.createGlue());
        JButton jButton4 = new JButton("<<<");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ConfigurationDialog.this._hostList.getSelectedValues();
                int n = 0;
                while (n < objectArray.length) {
                    ConfigurationDialog.this._hostListData.remove(ConfigurationDialog.this._hostListData.indexOf(objectArray[n]));
                    ConfigurationDialog.this._knownHostsData.add(objectArray[n]);
                    ConfigurationDialog.this.setListDisplay();
                    ++n;
                }
            }
        });
        jPanel7.add(jButton4);
        jPanel7.add(Box.createGlue());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        this._useHostList = new JCheckBox("Only monitor hosts in this list");
        jPanel8.add(this._useHostList);
        jPanel8.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 102)), " Hosts To Monitor "));
        this._hostList = new JList();
        this._hostList.setVisibleRowCount(10);
        JScrollPane jScrollPane2 = new JScrollPane(this._hostList);
        jPanel8.add(jScrollPane2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jPanel8, gridBagConstraints);
        jPanel3.add(jPanel8);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createServerOptions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this._connectControl = new JCheckBox("Automatically connect the control channel");
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this._connectControl, gridBagConstraints);
        jPanel.add(this._connectControl);
        this._connectData = new JCheckBox("Automatically connect the data channel");
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this._connectData, gridBagConstraints);
        jPanel.add(this._connectData);
        JLabel jLabel = new JLabel("i-scream server:");
        jLabel.setHorizontalAlignment(4);
        this._server = new JTextField(20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jLabel);
        jPanel2.add(this._server);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JLabel jLabel2 = new JLabel("Client interface port:");
        jLabel2.setHorizontalAlignment(4);
        this._port = new JTextField(4);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(jLabel2);
        jPanel3.add(this._port);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createFirewallOptions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this._useFirewall = new JCheckBox("Use firewall command to connect through to server");
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this._useFirewall, gridBagConstraints);
        jPanel.add(this._useFirewall);
        JLabel jLabel = new JLabel("Firewall command:");
        jLabel.setHorizontalAlignment(4);
        this._firewallCommand = new JTextField(20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jLabel);
        jPanel2.add(this._firewallCommand);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JLabel jLabel2 = new JLabel("Firewall wait time:");
        jLabel2.setHorizontalAlignment(4);
        this._firewallWait = new JTextField(2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(jLabel2);
        jPanel3.add(this._firewallWait);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JLabel jLabel3 = new JLabel("Firewall server:");
        jLabel3.setHorizontalAlignment(4);
        this._firewallServer = new JTextField(20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        jPanel4.add(jLabel3);
        jPanel4.add(this._firewallServer);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createDataOptions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this._displayQueue = new JCheckBox("Display server queue information");
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this._displayQueue, gridBagConstraints);
        jPanel.add(this._displayQueue);
        this._displayExtra = new JCheckBox("Display extra data found in packets");
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this._displayExtra, gridBagConstraints);
        jPanel.add(this._displayExtra);
        this._packetDump = new JCheckBox("Dump raw packet data to the console");
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this._packetDump, gridBagConstraints);
        jPanel.add(this._packetDump);
        JLabel jLabel = new JLabel("Maximum data queue size:");
        jLabel.setHorizontalAlignment(4);
        this._queueLimit = new JTextField(4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jLabel);
        jPanel2.add(this._queueLimit);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void getCurrentSettings() {
        this._name.setText(this._config.getProperty("clientname"));
        this._server.setText(this._config.getProperty("control.server"));
        this._port.setText(this._config.getProperty("control.port"));
        this._connectControl.setSelected(this._config.getProperty("control.onstartconnect").equals("1"));
        this._connectData.setSelected(this._config.getProperty("data.onstartconnect").equals("1"));
        this._firewallCommand.setText(this._config.getProperty("firewall.command"));
        this._firewallCommand.moveCaretPosition(0);
        this._firewallWait.setText(this._config.getProperty("firewall.commandwait"));
        this._firewallServer.setText(this._config.getProperty("firewall.server"));
        this._displayQueue.setSelected(this._config.getProperty("displayQueueInformation").equals("1"));
        this._displayExtra.setSelected(this._config.getProperty("displayExtraData").equals("1"));
        this._packetDump.setSelected(this._config.getProperty("packetDump").equals("1"));
        this._useFirewall.setSelected(this._config.getProperty("useFirewall").equals("1"));
        this._hostDiscoveryMode.setSelected(this._config.getProperty("hostDiscoveryMode").equals("1"));
        this._useHostList.setSelected(this._config.getProperty("useHostList").equals("1"));
        this._queueLimit.setText(this._config.getProperty("dataQueueSize"));
        this.prepareLists();
    }

    private void prepareLists() {
        this._knownHostsData = new ArrayList();
        this._hostListData = new ArrayList();
        String string = this._config.getProperty("knownHostsList");
        String string2 = this._config.getProperty("hostList");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) != -1) continue;
            this._knownHostsData.add(string3);
        }
        stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this._hostListData.add(stringTokenizer.nextToken());
        }
        this.setListDisplay();
    }

    private void setListDisplay() {
        Collections.sort(this._hostListData);
        Collections.sort(this._knownHostsData);
        this._knownHosts.setListData(this._knownHostsData.toArray());
        this._hostList.setListData(this._hostListData.toArray());
    }

    private void setNewSettingsAndClose() {
        this._config.setProperty("clientname", this._name.getText().trim());
        this._config.setProperty("control.server", this._server.getText().trim());
        this._config.setProperty("control.port", this._port.getText().trim());
        this._config.setProperty("firewall.command", this._firewallCommand.getText().trim());
        this._config.setProperty("firewall.commandwait", this._firewallWait.getText().trim());
        this._config.setProperty("firewall.server", this._firewallServer.getText().trim());
        this._config.setProperty("dataQueueSize", this._queueLimit.getText().trim());
        if (this._useFirewall.isSelected()) {
            this._config.setProperty("useFirewall", "1");
        } else {
            this._config.setProperty("useFirewall", "0");
        }
        if (this._connectControl.isSelected()) {
            this._config.setProperty("control.onstartconnect", "1");
        } else {
            this._config.setProperty("control.onstartconnect", "0");
        }
        if (this._connectData.isSelected()) {
            this._config.setProperty("data.onstartconnect", "1");
        } else {
            this._config.setProperty("data.onstartconnect", "0");
        }
        if (this._packetDump.isSelected()) {
            this._config.setProperty("packetDump", "1");
        } else {
            this._config.setProperty("packetDump", "0");
        }
        if (this._displayExtra.isSelected()) {
            this._config.setProperty("displayExtraData", "1");
        } else {
            this._config.setProperty("displayExtraData", "0");
        }
        if (this._displayQueue.isSelected()) {
            this._config.setProperty("displayQueueInformation", "1");
        } else {
            this._config.setProperty("displayQueueInformation", "0");
        }
        if (this._useHostList.isSelected()) {
            this._config.setProperty("useHostList", "1");
        } else {
            this._config.setProperty("useHostList", "0");
        }
        if (this._hostDiscoveryMode.isSelected()) {
            this._config.setProperty("hostDiscoveryMode", "1");
        } else {
            this._config.setProperty("hostDiscoveryMode", "0");
        }
        Iterator iterator = ((AbstractList)this._hostListData).iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = string + (String)iterator.next() + ";";
        }
        iterator = ((AbstractList)this._knownHostsData).iterator();
        String string2 = "";
        while (iterator.hasNext()) {
            string2 = string2 + (String)iterator.next() + ";";
        }
        string2 = string2 + string;
        this._config.setProperty("hostList", string);
        this._config.setProperty("knownHostsList", string2);
        this.dispose();
    }
}

