/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.StringUtils;

public class DateUtils {
    public final String REVISION = "$Revision: 1.5 $";
    public static final long secsPerMonth = 2592000L;
    public static final long secsPerWeek = 604800L;
    public static final long secsPerDay = 86400L;
    public static final long secsPerHour = 3600L;
    public static final long secsPerMin = 60L;
    private static final String daysKey = "%DAYS%";
    private static final String hoursKey = "%HOURS%";
    private static final String minsKey = "%MINS%";
    private static final String secsKey = "%SECS%";
    private String _name = null;

    public static long startOfToday() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        ParsePosition parsePosition = new ParsePosition(0);
        date = simpleDateFormat.parse(string, parsePosition);
        return date.getTime() / 1000L;
    }

    public static long now() {
        Date date = new Date();
        return date.getTime() / 1000L;
    }

    public static long subtractMonths(long l, int n) {
        return l - (long)n * 2592000L;
    }

    public static long subtractWeeks(long l, int n) {
        return l - (long)n * 604800L;
    }

    public static long subtractDays(long l, int n) {
        return l - (long)n * 86400L;
    }

    public static long subtractHours(long l, int n) {
        return l - (long)n * 3600L;
    }

    public static String dateString(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(l * 1000L);
        return simpleDateFormat.format(date);
    }

    public static String shortDateString(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(l * 1000L);
        return simpleDateFormat.format(date);
    }

    public static String hourString(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H");
        Date date = new Date(l * 1000L);
        return simpleDateFormat.format(date);
    }

    public static String dayName(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE");
        Date date = new Date(l * 1000L);
        return simpleDateFormat.format(date);
    }

    public static String timeString(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        Date date = new Date(l * 1000L);
        return simpleDateFormat.format(date);
    }

    public static String formatTime(long l) {
        String string = "Days: %DAYS%,  Hours: %HOURS%,  Mins: %MINS%,  Secs: %SECS%";
        return DateUtils.formatTime(l, string);
    }

    public static String formatTime(long l, String string) {
        String string2 = new Long(l / 86400L).toString();
        String string3 = new Long((l %= 86400L) / 3600L).toString();
        String string4 = new Long((l %= 3600L) / 60L).toString();
        String string5 = new Long(l %= 60L).toString();
        string = StringUtils.replaceText(string, daysKey, string2);
        string = StringUtils.replaceText(string, hoursKey, string3);
        string = StringUtils.replaceText(string, minsKey, string4);
        string = StringUtils.replaceText(string, secsKey, string5);
        return string;
    }

    public static String getTimeString(long l) {
        String string = null;
        string = l >= 3600L ? l / 60L / 60L + " hour(s)" : (l >= 60L ? l / 60L + " minute(s)" : l + " second(s)");
        return string;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.5 $");
    }
}

