untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFrd+1bLLQaMqNJUMFpxFs+36q8FvOXgJkWsEEWTe+roNFjldXm90PEHSRBAlnre4q+Pr+dSnMFe4XMV67G5IFQg=

OpenBSD 7.3 errata 012, July 24, 2023:

Add firmware for AMD cpus, to repair past or potential future bugs.
For i386 and amd64 platforms.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 012_amdfirmware.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And rebuild and install new bootblocks:
    cd /usr/src/sys/arch/`machine`/stand/
    make obj
    make
    make install

Also rebuild fw_update:
    cd /usr/src/usr.sbin/fw_update
    make obj
    make
    make install

New firmwares can be downloaded using
    fw_update

New bootblocks will need to be installed, using a command similar to this:
    installboot -v sd0

Index: sys/arch/amd64/stand/boot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/boot/conf.c,v
diff -u -p -u -r1.55 conf.c
--- sys/arch/amd64/stand/boot/conf.c	12 Aug 2022 20:18:58 -0000	1.55
+++ sys/arch/amd64/stand/boot/conf.c	23 Jul 2023 02:35:44 -0000
@@ -41,7 +41,7 @@
 #include <biosdev.h>
 #include <dev/cons.h>
 
-const char version[] = "3.55";
+const char version[] = "3.55b";
 int	debug = 1;
 
 
Index: sys/arch/amd64/stand/cdboot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/cdboot/conf.c,v
diff -u -p -u -r1.49 conf.c
--- sys/arch/amd64/stand/cdboot/conf.c	12 Aug 2022 20:18:58 -0000	1.49
+++ sys/arch/amd64/stand/cdboot/conf.c	23 Jul 2023 02:35:46 -0000
@@ -42,7 +42,7 @@
 #include <biosdev.h>
 #include <dev/cons.h>
 
-const char version[] = "3.55";
+const char version[] = "3.55b";
 int	debug = 1;
 
 
Index: sys/arch/amd64/stand/efi32/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/efi32/Attic/conf.c,v
diff -u -p -u -r1.11 conf.c
--- sys/arch/amd64/stand/efi32/conf.c	12 Aug 2022 20:18:58 -0000	1.11
+++ sys/arch/amd64/stand/efi32/conf.c	23 Jul 2023 02:35:48 -0000
@@ -40,7 +40,7 @@
 #include "efidev.h"
 #include "efipxe.h"
 
-const char version[] = "3.54";
+const char version[] = "3.54b";
 
 #ifdef EFI_DEBUG
 int	debug = 0;
Index: sys/arch/amd64/stand/efi64/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/efi64/Attic/conf.c,v
diff -u -p -u -r1.10 conf.c
--- sys/arch/amd64/stand/efi64/conf.c	12 Aug 2022 20:18:58 -0000	1.10
+++ sys/arch/amd64/stand/efi64/conf.c	23 Jul 2023 02:35:50 -0000
@@ -40,7 +40,7 @@
 #include "efidev.h"
 #include "efipxe.h"
 
-const char version[] = "3.54";
+const char version[] = "3.54b";
 
 #ifdef EFI_DEBUG
 int	debug = 0;
Index: sys/arch/amd64/stand/efiboot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/efiboot/conf.c,v
diff -u -p -u -r1.40 conf.c
--- sys/arch/amd64/stand/efiboot/conf.c	2 Jan 2023 22:41:17 -0000	1.40
+++ sys/arch/amd64/stand/efiboot/conf.c	23 Jul 2023 02:35:41 -0000
@@ -40,7 +40,7 @@
 #include "efidev.h"
 #include "efipxe.h"
 
-const char version[] = "3.63";
+const char version[] = "3.63b";
 
 #ifdef EFI_DEBUG
 int	debug = 0;
Index: sys/arch/amd64/stand/efiboot/exec_i386.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/efiboot/exec_i386.c,v
diff -u -p -u -r1.10 exec_i386.c
--- sys/arch/amd64/stand/efiboot/exec_i386.c	23 Feb 2023 19:48:21 -0000	1.10
+++ sys/arch/amd64/stand/efiboot/exec_i386.c	23 Jul 2023 02:36:41 -0000
@@ -180,7 +180,8 @@ ucode_load(void)
 
 	CPUID(0, dummy, vendor[0], vendor[2], vendor[1]);
 	vendor[3] = 0; /* NULL-terminate */
-	if (strcmp((char *)vendor, "GenuineIntel") != 0)
+	if (strcmp((char *)vendor, "GenuineIntel") != 0 &&
+	    strcmp((char *)vendor, "AuthenticAMD") != 0)
 		return;
 
 	CPUID(1, signature, dummy, dummy, dummy);
@@ -192,8 +193,22 @@ ucode_load(void)
 	}
 	stepping = (signature >> 0) & 0x0f;
 
-	snprintf(path, sizeof(path), "%s:/etc/firmware/intel/%02x-%02x-%02x",
-	    cmd.bootdev, family, model, stepping);
+	if (strcmp((char *)vendor, "GenuineIntel") == 0) {
+		snprintf(path, sizeof(path),
+		    "%s:/etc/firmware/intel/%02x-%02x-%02x",
+		    cmd.bootdev, family, model, stepping);
+	} else if (strcmp((char *)vendor, "AuthenticAMD") == 0) {
+		if (family < 0x10)
+			return;
+		else if (family <= 0x14)
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd.bin",
+			    cmd.bootdev);
+		else
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd_fam%02xh.bin",
+			    cmd.bootdev, family);
+	}
 
 	fd = open(path, O_RDONLY);
 	if (fd == -1)
Index: sys/arch/amd64/stand/libsa/exec_i386.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/libsa/exec_i386.c,v
diff -u -p -u -r1.37 exec_i386.c
--- sys/arch/amd64/stand/libsa/exec_i386.c	11 Jul 2022 19:45:02 -0000	1.37
+++ sys/arch/amd64/stand/libsa/exec_i386.c	23 Jul 2023 02:36:41 -0000
@@ -202,7 +202,8 @@ ucode_load(void)
 
 	CPUID(0, dummy, vendor[0], vendor[2], vendor[1]);
 	vendor[3] = 0; /* NULL-terminate */
-	if (strcmp((char *)vendor, "GenuineIntel") != 0)
+	if (strcmp((char *)vendor, "GenuineIntel") != 0 &&
+	    strcmp((char *)vendor, "AuthenticAMD") != 0)
 		return;
 
 	CPUID(1, signature, dummy, dummy, dummy);
@@ -214,8 +215,22 @@ ucode_load(void)
 	}
 	stepping = (signature >> 0) & 0x0f;
 
-	snprintf(path, sizeof(path), "%s:/etc/firmware/intel/%02x-%02x-%02x",
-	    cmd.bootdev, family, model, stepping);
+	if (strcmp((char *)vendor, "GenuineIntel") == 0) {
+		snprintf(path, sizeof(path),
+		    "%s:/etc/firmware/intel/%02x-%02x-%02x",
+		    cmd.bootdev, family, model, stepping);
+	} else if (strcmp((char *)vendor, "AuthenticAMD") == 0) {
+		if (family < 0x10)
+			return;
+		else if (family <= 0x14)
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd.bin",
+			    cmd.bootdev);
+		else
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd_fam%02xh.bin",
+			    cmd.bootdev, family);
+	}
 
 	fd = open(path, O_RDONLY);
 	if (fd == -1)
Index: sys/arch/amd64/stand/pxeboot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/stand/pxeboot/conf.c,v
diff -u -p -u -r1.54 conf.c
--- sys/arch/amd64/stand/pxeboot/conf.c	12 Aug 2022 20:18:58 -0000	1.54
+++ sys/arch/amd64/stand/pxeboot/conf.c	23 Jul 2023 02:35:38 -0000
@@ -44,7 +44,7 @@
 #include "pxeboot.h"
 #include "pxe_net.h"
 
-const char version[] = "3.55";
+const char version[] = "3.55b";
 int	debug = 0;
 
 void (*sa_cleanup)(void) = pxe_shutdown;
Index: sys/arch/i386/stand/boot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/stand/boot/conf.c,v
diff -u -p -u -r1.76 conf.c
--- sys/arch/i386/stand/boot/conf.c	9 Dec 2020 18:10:18 -0000	1.76
+++ sys/arch/i386/stand/boot/conf.c	23 Jul 2023 02:36:09 -0000
@@ -42,7 +42,7 @@
 #include <dev/cons.h>
 #include "debug.h"
 
-const char version[] = "3.44";
+const char version[] = "3.44b";
 int	debug = 1;
 
 
Index: sys/arch/i386/stand/cdboot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/stand/cdboot/conf.c,v
diff -u -p -u -r1.43 conf.c
--- sys/arch/i386/stand/cdboot/conf.c	9 Dec 2020 18:10:18 -0000	1.43
+++ sys/arch/i386/stand/cdboot/conf.c	23 Jul 2023 02:36:05 -0000
@@ -43,7 +43,7 @@
 #include <dev/cons.h>
 #include "debug.h"
 
-const char version[] = "3.44";
+const char version[] = "3.44b";
 int	debug = 1;
 
 void (*sa_cleanup)(void) = NULL;
Index: sys/arch/i386/stand/libsa/exec_i386.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/stand/libsa/exec_i386.c,v
diff -u -p -u -r1.52 exec_i386.c
--- sys/arch/i386/stand/libsa/exec_i386.c	7 Jul 2022 00:56:47 -0000	1.52
+++ sys/arch/i386/stand/libsa/exec_i386.c	23 Jul 2023 02:36:41 -0000
@@ -190,7 +190,8 @@ ucode_load(void)
 
 	CPUID(0, dummy, vendor[0], vendor[2], vendor[1]);
 	vendor[3] = 0; /* NULL-terminate */
-	if (strcmp((char *)vendor, "GenuineIntel") != 0)
+	if (strcmp((char *)vendor, "GenuineIntel") != 0 &&
+	    strcmp((char *)vendor, "AuthenticAMD") != 0)
 		return;
 
 	CPUID(1, signature, dummy, dummy, dummy);
@@ -202,8 +203,22 @@ ucode_load(void)
 	}
 	stepping = (signature >> 0) & 0x0f;
 
-	snprintf(path, sizeof(path), "%s:/etc/firmware/intel/%02x-%02x-%02x",
-	    cmd.bootdev, family, model, stepping);
+	if (strcmp((char *)vendor, "GenuineIntel") == 0) {
+		snprintf(path, sizeof(path),
+		    "%s:/etc/firmware/intel/%02x-%02x-%02x",
+		    cmd.bootdev, family, model, stepping);
+	} else if (strcmp((char *)vendor, "AuthenticAMD") == 0) {
+		if (family < 0x10)
+			return;
+		else if (family <= 0x14)
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd.bin",
+			    cmd.bootdev);
+		else
+			snprintf(path, sizeof(path),
+			    "%s:/etc/firmware/amd/microcode_amd_fam%02xh.bin",
+			    cmd.bootdev, family);
+	}
 
 	fd = open(path, O_RDONLY);
 	if (fd == -1)
Index: sys/arch/i386/stand/libsa/pciprobe.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/stand/libsa/pciprobe.c,v
diff -u -p -u -r1.10 pciprobe.c
--- sys/arch/i386/stand/libsa/pciprobe.c	29 Mar 2014 18:09:29 -0000	1.10
+++ sys/arch/i386/stand/libsa/pciprobe.c	24 Jul 2023 13:47:48 -0000
@@ -39,12 +39,12 @@ pciprobe(void)
 {
 	bios_pciinfo_t bpi;
 	u_int32_t hw_chars, rev, rc, sig;
-	u_int32_t entry32;
+	u_int32_t entry32, lastbus;
 
 	/* PCI BIOS v2.0c+ - Installation Check */
-	__asm volatile(DOINT(0x1A) "; shll $8,%2; setc %b2"
-		: "=a" (hw_chars), "=b" (rev), "=c" (rc),
-		  "=d" (sig), "=D" (entry32)
+	__asm volatile(DOINT(0x1A)
+		: "=a" (hw_chars), "=b" (rev), "=c" (lastbus),
+		  "=d" (sig), "=D" (entry32), "=@ccc" (rc)
 		: "0" (0xB101), "4" (0x0)
 		: "cc");
 
@@ -62,7 +62,7 @@ pciprobe(void)
 	bpi.pci_chars = hw_chars & 0xFFFF;
 	bpi.pci_rev = rev & 0xFFFF;
 	bpi.pci_entry32 = entry32;
-	bpi.pci_lastbus = (rc>>8) & 0xFF;
+	bpi.pci_lastbus = lastbus & 0xFF;
 
 	addbootarg(BOOTARG_PCIINFO, sizeof(bios_pciinfo_t), &bpi);
 }
Index: sys/arch/i386/stand/pxeboot/conf.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/stand/pxeboot/conf.c,v
diff -u -p -u -r1.48 conf.c
--- sys/arch/i386/stand/pxeboot/conf.c	9 Dec 2020 18:10:18 -0000	1.48
+++ sys/arch/i386/stand/pxeboot/conf.c	23 Jul 2023 02:36:02 -0000
@@ -45,7 +45,7 @@
 #include "pxeboot.h"
 #include "pxe_net.h"
 
-const char version[] = "3.44";
+const char version[] = "3.44b";
 int	debug = 1;
 
 void (*sa_cleanup)(void) = pxe_shutdown;
Index: usr.sbin/fw_update/patterns.c
===================================================================
RCS file: /cvs/src/usr.sbin/fw_update/patterns.c,v
diff -u -p -u -r1.8 patterns.c
--- usr.sbin/fw_update/patterns.c	16 Feb 2023 03:09:33 -0000	1.8
+++ usr.sbin/fw_update/patterns.c	23 Jul 2023 02:33:26 -0000
@@ -88,6 +88,8 @@ int
 main(void)
 {
 	printf("%s\n", "acx");
+	printf("%s\n", "amd");
+	printf("%s\n", "amd ^cpu0:* AMD");
 	printf("%s\n", "amdgpu");
 	print_devices("amdgpu", amdgpu_devices, nitems(amdgpu_devices));
 	printf("%s\n", "amdgpu ^vga*vendor \"ATI\", unknown product"); 
