untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTSrxcObhS4LrlOxNua8LTTS2K6IdcqSzD6KGG0ChqAOWcIbhs8+g3AoCqOgAdO9gA/1WT0u4xWg1Oux5Qia5ugQ=

OpenBSD 7.1 errata 016, December 14, 2022:

TLB entries were not invalidated for all types of engine on 
12th generation Intel graphics (Tiger Lake, Rocket Lake, Alder Lake).

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 016_gpuinv.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/i915/gt/intel_gt.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gt/intel_gt.c,v
diff -u -p -r1.5 intel_gt.c
--- sys/dev/pci/drm/i915/gt/intel_gt.c	29 Jan 2022 12:37:09 -0000	1.5
+++ sys/dev/pci/drm/i915/gt/intel_gt.c	11 Dec 2022 07:31:51 -0000
@@ -988,6 +988,10 @@ void intel_gt_invalidate_tlbs(struct int
 		if (!i915_mmio_reg_offset(rb.reg))
 			continue;
 
+		if (GRAPHICS_VER(i915) == 12 && (engine->class == VIDEO_DECODE_CLASS ||
+		    engine->class == VIDEO_ENHANCEMENT_CLASS))
+			rb.bit = _MASKED_BIT_ENABLE(rb.bit);
+
 		intel_uncore_write_fw(uncore, rb.reg, rb.bit);
 		if (__intel_wait_for_register_fw(uncore,
 						 rb.reg, rb.bit, 0,
