untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTdcdKdiTHOQXBbmwOjSAQF8p2vjvE6QO4MVOM0m3Kwj5/DpV5CqggoO9EVq9X2gtYdF2t1h7fwLHwhsYEMuLHQo=

OpenBSD 7.1 errata 027, March 23, 2023:

Incorrect length checks allow an out-of-bounds read in bgpd(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 027_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/rde.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde.c,v
diff -u -p -r1.544.2.1 rde.c
--- usr.sbin/bgpd/rde.c	1 Aug 2022 11:02:16 -0000	1.544.2.1
+++ usr.sbin/bgpd/rde.c	21 Mar 2023 12:29:51 -0000
@@ -1943,7 +1943,7 @@ bad_flags:
 			goto bad_flags;
 		goto optattr;
 	case ATTR_MP_REACH_NLRI:
-		if (attr_len < 4)
+		if (attr_len < 5)
 			goto bad_len;
 		if (!CHECK_FLAGS(flags, ATTR_OPTIONAL, 0))
 			goto bad_flags;
@@ -2109,7 +2109,7 @@ rde_get_mp_nexthop(u_char *data, uint16_
 	totlen = 1;
 	len--;
 
-	if (nhlen > len)
+	if (nhlen + 1 > len)
 		return (-1);
 
 	bzero(&nexthop, sizeof(nexthop));
