untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46A/dXQ9EfCv5JIeT9+FVDbfbMBshyiXE/A98PFo36eG+tYYTmBc0V4I8OhVTOOQ/SgP9R6lPVA09hAJxV1mPOQ8=

OpenBSD 6.9 errata 010, July 25, 2021:

relayd(8), when using the the http protocol strip filter directive or http
protocol macro expansion, processes format strings.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 010_relayd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install relayd(8):
    cd /usr/src/usr.sbin/relayd
    make obj
    make
    make install

Index: usr.sbin/relayd/relay_http.c
===================================================================
RCS file: /cvs/src/usr.sbin/relayd/relay_http.c,v
diff -u -p -r1.81 relay_http.c
--- usr.sbin/relayd/relay_http.c	24 Mar 2021 20:59:54 -0000	1.81
+++ usr.sbin/relayd/relay_http.c	23 Jul 2021 18:45:30 -0000
@@ -1735,7 +1735,7 @@ relay_apply_actions(struct ctl_relay_eve
 		case KEY_OPTION_STRIP:
 			nstrip = strtonum(kv->kv_value, 0, INT_MAX, NULL);
 			if (kv->kv_type == KEY_TYPE_PATH) {
-				if (kv_setkey(match,
+				if (kv_setkey(match, "%s",
 				    server_root_strip(match->kv_key,
 				    nstrip)) == -1)
 					goto fail;
@@ -1763,7 +1763,7 @@ relay_apply_actions(struct ctl_relay_eve
 			if ((ptr = relay_expand_http(cre, kp->kv_value, buf,
 			    sizeof(buf))) == NULL)
 				goto fail;
-			if (kv_set(match, ptr) == -1)
+			if (kv_set(match, "%s", ptr) == -1)
 				goto fail;
 		}
 
Index: usr.sbin/relayd/relayd.h
===================================================================
RCS file: /cvs/src/usr.sbin/relayd/relayd.h,v
diff -u -p -r1.266 relayd.h
--- usr.sbin/relayd/relayd.h	23 Mar 2021 16:34:31 -0000	1.266
+++ usr.sbin/relayd/relayd.h	23 Jul 2021 18:45:30 -0000
@@ -1355,8 +1355,10 @@ u_int32_t	 prefixlen2mask(u_int8_t);
 int		 accept_reserve(int, struct sockaddr *, socklen_t *, int,
 		     volatile int *);
 struct kv	*kv_add(struct kvtree *, char *, char *, int);
-int		 kv_set(struct kv *, char *, ...);
-int		 kv_setkey(struct kv *, char *, ...);
+int		 kv_set(struct kv *, char *, ...)
+				__attribute__((__format__ (printf, 2, 3)));
+int		 kv_setkey(struct kv *, char *, ...)
+				__attribute__((__format__ (printf, 2, 3)));
 void		 kv_delete(struct kvtree *, struct kv *);
 struct kv	*kv_extend(struct kvtree *, struct kv *, char *);
 void		 kv_purge(struct kvtree *);
