untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2qkd/+YfccIMDQ8KB/RtcOCGyIIRk/a6w6TI7SChdZMFfyWqtHPoFaGBmfv6jG0H+AQP1eMmdKltrxsN1LaS4Qk=

OpenBSD 6.8 errata 031, September 27, 2021:

A stack overread could occur when checking X.509 name constraints.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 031_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto, isakmpd and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install
    cd /usr/src/sbin/isakmpd
    make obj
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/x509/x509_constraints.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_constraints.c,v
diff -u -p -r1.10 x509_constraints.c
--- lib/libcrypto/x509/x509_constraints.c	21 Sep 2020 05:41:43 -0000	1.10
+++ lib/libcrypto/x509/x509_constraints.c	23 Sep 2021 17:00:34 -0000
@@ -323,16 +323,16 @@ x509_constraints_parse_mailbox(uint8_t *
 			if (c == '.')
 				goto bad;
 		}
-		if (wi > DOMAIN_PART_MAX_LEN)
-			goto bad;
 		if (accept) {
+			if (wi >= DOMAIN_PART_MAX_LEN)
+				goto bad;
 			working[wi++] = c;
 			accept = 0;
 			continue;
 		}
 		if (candidate_local != NULL) {
 			/* We are looking for the domain part */
-			if (wi > DOMAIN_PART_MAX_LEN)
+			if (wi >= DOMAIN_PART_MAX_LEN)
 				goto bad;
 			working[wi++] = c;
 			if (i == len - 1) {
@@ -347,7 +347,7 @@ x509_constraints_parse_mailbox(uint8_t *
 			continue;
 		}
 		/* We are looking for the local part */
-		if (wi > LOCAL_PART_MAX_LEN)
+		if (wi >= LOCAL_PART_MAX_LEN)
 			break;
 
 		if (quoted) {
@@ -367,6 +367,8 @@ x509_constraints_parse_mailbox(uint8_t *
 			 */
 			if (c == 9)
 				goto bad;
+			if (wi >= LOCAL_PART_MAX_LEN)
+				goto bad;
 			working[wi++] = c;
 			continue; /* all's good inside our quoted string */
 		}
@@ -395,6 +397,8 @@ x509_constraints_parse_mailbox(uint8_t *
 			accept = 1;
 		}
 		if (!local_part_ok(c))
+			goto bad;
+		if (wi >= LOCAL_PART_MAX_LEN)
 			goto bad;
 		working[wi++] = c;
 	}
