untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT8/ATk9tnilH6wyjykitB1H/ggOtEDL8TQNUnKaU8i4ylv1rp1OLILixSriPRDAU9eN2hNuJJhrV6MB4sk1FsQ4=

OpenBSD 6.5 errata 004, June 10, 2019:

Several issues were corrected in bgpd: "network" statements with no fixed
prefix were incorrectly removed when configuration was reloaded, "export
default-route" did not work, and "network 0.0.0.0/0" could not be used
in some cases.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 004_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd:
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/kroute.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/kroute.c,v
retrieving revision 1.235
diff -u -p -r1.235 kroute.c
--- usr.sbin/bgpd/kroute.c	7 Mar 2019 07:42:36 -0000	1.235
+++ usr.sbin/bgpd/kroute.c	3 Jun 2019 16:17:10 -0000
@@ -1230,19 +1230,19 @@ kr_net_redist_add(struct ktable *kt, str
 
 	xr = RB_INSERT(kredist_tree, &kt->kredist, r);
 	if (xr != NULL) {
-		if (dynamic == xr->dynamic || dynamic) {
+		free(r);
+
+		if (dynamic != xr->dynamic && dynamic) {
 			/*
-			 * ignore update, equal announcement already present,
-			 * or a non-dynamic announcement is already present
-			 * which has preference.
+			 * ignore update a non-dynamic announcement is
+			 * already present which has preference.
 			 */
-			free(r);
 			return 0;
 		}
 		/*
-		 * only the case where xr->dynamic == 1 and dynamic == 0
-		 * ends up here and in this case non-dynamic announcments
-		 * are preferred. Override dynamic flag.
+		 * only equal or non-dynamic announcement ends up here.
+		 * In both cases reset the dynamic flag (nop for equal) and
+		 * redistribute.
 		 */
 		xr->dynamic = dynamic;
 	}
@@ -1281,7 +1281,6 @@ int
 kr_net_match(struct ktable *kt, struct network_config *net, u_int16_t flags)
 {
 	struct network		*xn;
-	int			 matched = 0;
 
 	TAILQ_FOREACH(xn, &kt->krn, entry) {
 		if (xn->net.prefix.aid != net->prefix.aid)
@@ -1316,9 +1315,9 @@ kr_net_match(struct ktable *kt, struct n
 
 		net->rd = xn->net.rd;
 		if (kr_net_redist_add(kt, net, &xn->net.attrset, 1))
-			matched = 1;
+			return (1);
 	}
-	return matched;
+	return (0);
 }
 
 struct network *
Index: usr.sbin/bgpd/parse.y
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/parse.y,v
retrieving revision 1.386
diff -u -p -r1.386 parse.y
--- usr.sbin/bgpd/parse.y	10 Apr 2019 15:21:54 -0000	1.386
+++ usr.sbin/bgpd/parse.y	3 Jun 2019 16:17:10 -0000
@@ -863,7 +863,8 @@ network		: NETWORK prefix filter_set	{
 			filterset_move($3, &n->net.attrset);
 			free($3);
 			TAILQ_FOREACH(m, netconf, entry) {
-				if (n->net.prefixlen == m->net.prefixlen &&
+				if (n->net.type == m->net.type &&
+				    n->net.prefixlen == m->net.prefixlen &&
 				    prefix_compare(&n->net.prefix,
 				    &m->net.prefix, n->net.prefixlen) == 0)
 					yyerror("duplicate prefix "
Index: usr.sbin/bgpd/rde_update.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde_update.c,v
retrieving revision 1.108
diff -u -p -r1.108 rde_update.c
--- usr.sbin/bgpd/rde_update.c	21 Jan 2019 02:07:56 -0000	1.108
+++ usr.sbin/bgpd/rde_update.c	3 Jun 2019 16:17:10 -0000
@@ -224,8 +224,11 @@ up_generate_default(struct filter_head *
 		return;
 	}
 
-	path_update(&ribs[RIB_ADJ_OUT].rib, peer, &state, &addr, 0,
-	    ROA_NOTFOUND);
+	if (path_update(&ribs[RIB_ADJ_OUT].rib, peer, &state, &addr, 0,
+	    ROA_NOTFOUND) != 2) {
+		prefix_update(&ribs[RIB_ADJ_OUT].rib, peer, &addr, 0);
+		peer->up_nlricnt++;
+	}
 
 	/* no longer needed */
 	rde_filterstate_clean(&state);
