untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZYAfG6MFoKJNzrusDrl83pEWqz7tgRZC1FGX8MkgRvADnj7DbU/6EsF63QBjvDGt8H9v9XjexGsoFIuTK8ODMQo=

OpenBSD 6.3 errata 002, April 21, 2018:

Additional data is inadvertently removed when private keys are cleared from
TLS configuration, which can prevent OCSP from functioning correctly.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 002_libtls.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
    cd /usr/src/lib/libtls
    make obj
    make
    make install

Index: lib/libtls/tls_config.c
===================================================================
RCS file: /cvs/src/lib/libtls/tls_config.c,v
retrieving revision 1.51
retrieving revision 1.51.2.1
diff -u -p -r1.51 -r1.51.2.1
--- lib/libtls/tls_config.c	20 Mar 2018 15:40:10 -0000	1.51
+++ lib/libtls/tls_config.c	18 Apr 2018 16:29:11 -0000	1.51.2.1
@@ -189,10 +189,7 @@ tls_config_clear_keys(struct tls_config 
 	struct tls_keypair *kp;
 
 	for (kp = config->keypair; kp != NULL; kp = kp->next)
-		tls_keypair_clear(kp);
-
-	tls_config_set_ca_mem(config, NULL, 0);
-	tls_config_set_crl_mem(config, NULL, 0);
+		tls_keypair_clear_key(kp);
 }
 
 int
Index: lib/libtls/tls_internal.h
===================================================================
RCS file: /cvs/src/lib/libtls/tls_internal.h,v
retrieving revision 1.71
retrieving revision 1.71.2.1
diff -u -p -r1.71 -r1.71.2.1
--- lib/libtls/tls_internal.h	19 Mar 2018 16:34:47 -0000	1.71
+++ lib/libtls/tls_internal.h	18 Apr 2018 16:29:11 -0000	1.71.2.1
@@ -199,6 +199,7 @@ int tls_set_mem(char **_dest, size_t *_d
 int tls_set_string(const char **_dest, const char *_src);
 
 struct tls_keypair *tls_keypair_new(void);
+void tls_keypair_clear_key(struct tls_keypair *_keypair);
 void tls_keypair_clear(struct tls_keypair *_keypair);
 void tls_keypair_free(struct tls_keypair *_keypair);
 int tls_keypair_set_cert_file(struct tls_keypair *_keypair,
Index: lib/libtls/tls_keypair.c
===================================================================
RCS file: /cvs/src/lib/libtls/tls_keypair.c,v
retrieving revision 1.5
retrieving revision 1.5.2.1
diff -u -p -r1.5 -r1.5.2.1
--- lib/libtls/tls_keypair.c	10 Feb 2018 04:57:35 -0000	1.5
+++ lib/libtls/tls_keypair.c	18 Apr 2018 16:29:11 -0000	1.5.2.1
@@ -29,7 +29,7 @@ tls_keypair_new(void)
 	return calloc(1, sizeof(struct tls_keypair));
 }
 
-static void
+void
 tls_keypair_clear_key(struct tls_keypair *keypair)
 {
 	freezero(keypair->key_mem, keypair->key_len);
