untrusted comment: verify with openbsd-63-base.pub
RWRxzbLwAd76ZTrrTD+k7XbjwiwSPll/Qm+hmSWoNQAclkn3WHM3qjEO6i0K0Ib3XROxbfT91n8GBHW14SLnLJxJL59CpD6MzQw=

OpenBSD 6.3 errata 030, March 1, 2019:

Fragmented IPv6 packets may be erroneously passed by pf or lead to a crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 030_pf6frag.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf_norm.c
===================================================================
RCS file: /cvs/src/sys/net/pf_norm.c,v
retrieving revision 1.209
diff -u -p -r1.209 pf_norm.c
--- sys/net/pf_norm.c	6 Feb 2018 09:16:11 -0000	1.209
+++ sys/net/pf_norm.c	27 Feb 2019 16:05:32 -0000
@@ -723,10 +723,10 @@ pf_reassemble6(struct mbuf **m0, struct 
 	}
 
 	/* We have all the data */
-	extoff = frent->fe_extoff;
-	maxlen = frag->fr_maxlen;
 	frent = TAILQ_FIRST(&frag->fr_queue);
 	KASSERT(frent != NULL);
+	extoff = frent->fe_extoff;
+	maxlen = frag->fr_maxlen;
 	total = TAILQ_LAST(&frag->fr_queue, pf_fragq)->fe_off +
 	    TAILQ_LAST(&frag->fr_queue, pf_fragq)->fe_len;
 	hdrlen = frent->fe_hdrlen - sizeof(struct ip6_frag);
